/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonParser {
    private final char[] json;
    private final boolean keepNulls;
    private final int len;
    private int idx;
    private int nextIdx;
    private char previous;
    private char current;
    private char next;

    public static JsonValue parse(char[] json) throws JsonParseException {
        return new JsonParser(json, 0, new Option[0]).parse();
    }

    public static JsonValue parse(char[] json, int startIndex) throws JsonParseException {
        return new JsonParser(json, startIndex, new Option[0]).parse();
    }

    public static JsonValue parse(char[] json, Option ... options) throws JsonParseException {
        return new JsonParser(json, 0, options).parse();
    }

    public static JsonValue parse(char[] json, int startIndex, Option ... options) throws JsonParseException {
        return new JsonParser(json, startIndex, options).parse();
    }

    public static JsonValue parse(String json) throws JsonParseException {
        return new JsonParser(json.toCharArray(), 0, new Option[0]).parse();
    }

    public static JsonValue parse(String json, int startIndex) throws JsonParseException {
        return new JsonParser(json.toCharArray(), startIndex, new Option[0]).parse();
    }

    public static JsonValue parse(String json, Option ... options) throws JsonParseException {
        return new JsonParser(json.toCharArray(), 0, options).parse();
    }

    public static JsonValue parse(String json, int startIndex, Option ... options) throws JsonParseException {
        return new JsonParser(json.toCharArray(), startIndex, options).parse();
    }

    public static JsonValue parse(byte[] json) throws JsonParseException {
        return new JsonParser(new String(json, StandardCharsets.UTF_8).toCharArray(), 0, new Option[0]).parse();
    }

    public static JsonValue parse(byte[] json, Option ... options) throws JsonParseException {
        return new JsonParser(new String(json, StandardCharsets.UTF_8).toCharArray(), 0, options).parse();
    }

    public static JsonValue parseUnchecked(char[] json) {
        try {
            return JsonParser.parse(json);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static JsonValue parseUnchecked(char[] json, int startIndex) {
        try {
            return JsonParser.parse(json, startIndex);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static JsonValue parseUnchecked(char[] json, Option ... options) {
        try {
            return JsonParser.parse(json, options);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static JsonValue parseUnchecked(char[] json, int startIndex, Option ... options) {
        try {
            return JsonParser.parse(json, startIndex, options);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static JsonValue parseUnchecked(String json) {
        try {
            return JsonParser.parse(json);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static JsonValue parseUnchecked(String json, int startIndex) {
        try {
            return JsonParser.parse(json, startIndex);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static JsonValue parseUnchecked(String json, Option ... options) {
        try {
            return JsonParser.parse(json, options);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static JsonValue parseUnchecked(String json, int startIndex, Option ... options) {
        try {
            return JsonParser.parse(json, startIndex, options);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static JsonValue parseUnchecked(byte[] json) {
        try {
            return JsonParser.parse(json);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public static JsonValue parseUnchecked(byte[] json, Option ... options) {
        try {
            return JsonParser.parse(json, options);
        }
        catch (JsonParseException j) {
            throw new RuntimeException(j);
        }
    }

    public JsonParser(char[] json) {
        this(json, 0, new Option[0]);
    }

    public JsonParser(char[] json, Option ... options) {
        this(json, 0, options);
    }

    public JsonParser(char[] json, int startIndex, Option ... options) {
        this.json = json;
        boolean kn = false;
        for (Option o : options) {
            if (o != Option.KEEP_NULLS) continue;
            kn = true;
            break;
        }
        this.keepNulls = kn;
        this.len = json == null ? 0 : json.length;
        this.idx = startIndex;
        if (startIndex < 0) {
            throw new IllegalArgumentException("Invalid start index.");
        }
        this.nextIdx = -1;
        this.previous = '\u0000';
        this.current = '\u0000';
        this.next = '\u0000';
    }

    public JsonValue parse() throws JsonParseException {
        char c = this.peekToken();
        if (c == '\u0000') {
            return JsonValue.NULL;
        }
        return this.nextValue();
    }

    private JsonValue nextValue() throws JsonParseException {
        char c = this.peekToken();
        if (c == '\u0000') {
            throw new JsonParseException("Unexpected end of data.");
        }
        if (c == '\"') {
            this.nextToken();
            return new JsonValue(this.nextString());
        }
        if (c == '{') {
            this.nextToken();
            return new JsonValue(this.nextObject());
        }
        if (c == '[') {
            this.nextToken();
            return new JsonValue(this.nextArray());
        }
        return this.nextPrimitiveValue();
    }

    private List<JsonValue> nextArray() throws JsonParseException {
        ArrayList<JsonValue> list = new ArrayList<JsonValue>();
        char p = this.peekToken();
        while (p != ']') {
            if (p == ',') {
                this.nextToken();
            } else {
                list.add(this.nextValue());
            }
            p = this.peekToken();
        }
        this.nextToken();
        return list;
    }

    private JsonValue nextPrimitiveValue() throws JsonParseException {
        StringBuilder sb = new StringBuilder();
        char c = this.peekToken();
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            sb.append(this.nextToken());
            c = this.peekToken();
        }
        String string = sb.toString();
        if ("true".equalsIgnoreCase(string)) {
            return new JsonValue(Boolean.TRUE);
        }
        if ("false".equalsIgnoreCase(string)) {
            return new JsonValue(Boolean.FALSE);
        }
        if ("null".equalsIgnoreCase(string)) {
            return JsonValue.NULL;
        }
        try {
            return this.asNumber(string);
        }
        catch (Exception e) {
            throw new JsonParseException("Invalid value.");
        }
    }

    private Map<String, JsonValue> nextObject() throws JsonParseException {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        block9: while (true) {
            char c = this.nextToken();
            switch (c) {
                case '\u0000': {
                    throw new JsonParseException("Text must end with '}'");
                }
                case '}': {
                    return map;
                }
                case '[': 
                case '{': {
                    if (this.previous != '{') break;
                    throw new JsonParseException("Cannot directly nest another Object or Array.");
                }
            }
            String key = this.nextString();
            c = this.nextToken();
            if (c != ':') {
                throw new JsonParseException("Expected a ':' after a key.");
            }
            JsonValue value = this.nextValue();
            if (value != JsonValue.NULL || this.keepNulls) {
                map.put(key, value);
            }
            switch (this.nextToken()) {
                case ',': {
                    if (this.peekToken() != '}') continue block9;
                    return map;
                }
                case '}': {
                    return map;
                }
            }
            break;
        }
        throw new JsonParseException("Expected a ',' or '}'.");
    }

    private char nextToken() {
        this.peekToken();
        this.idx = this.nextIdx;
        this.nextIdx = -1;
        this.previous = this.current;
        this.current = this.next;
        this.next = '\u0000';
        return this.current;
    }

    private char nextChar() {
        this.previous = this.current;
        this.current = this.idx == this.len ? (char)'\u0000' : this.json[this.idx++];
        this.next = '\u0000';
        this.nextIdx = -1;
        return this.current;
    }

    private char peekToken() {
        if (this.nextIdx == -1) {
            this.nextIdx = this.idx;
            this.next = '\u0000';
            block3: while (this.nextIdx < this.len) {
                char c = this.json[this.nextIdx++];
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                }
                this.next = c;
                return this.next;
            }
        }
        return this.next;
    }

    private String nextString() throws JsonParseException {
        StringBuilder sb = new StringBuilder();
        block13: while (true) {
            char c = this.nextChar();
            switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw new JsonParseException("Unterminated string.");
                }
                case '\\': {
                    c = this.nextChar();
                    switch (c) {
                        case 'b': {
                            sb.append('\b');
                            continue block13;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            sb.append(this.parseU());
                            continue block13;
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            sb.append(c);
                            continue block13;
                        }
                    }
                    throw new JsonParseException("Illegal escape.");
                }
            }
            if (c == '\"') {
                return sb.toString();
            }
            sb.append(c);
        }
    }

    private char[] parseU() throws JsonParseException {
        char[] a = new char[4];
        for (int x = 0; x < 4; ++x) {
            a[x] = this.nextToken();
            if (a[x] != '\u0000') continue;
            throw new JsonParseException("Illegal escape.");
        }
        try {
            int code = Integer.parseInt("" + a[0] + a[1] + a[2] + a[3], 16);
            return Character.toChars(code);
        }
        catch (RuntimeException e) {
            throw new JsonParseException("Illegal escape.", e);
        }
    }

    private JsonValue asNumber(String val) throws JsonParseException {
        char initial = val.charAt(0);
        if (initial >= '0' && initial <= '9' || initial == '-') {
            BigInteger bi;
            char at1;
            if (JsonParser.isDecimalNotation(val)) {
                try {
                    BigDecimal bd = new BigDecimal(val);
                    if (initial == '-' && BigDecimal.ZERO.compareTo(bd) == 0) {
                        return new JsonValue(-0.0);
                    }
                    return new JsonValue(bd);
                }
                catch (NumberFormatException retryAsDouble) {
                    try {
                        double d = Double.parseDouble(val);
                        if (Double.isNaN(d) || Double.isInfinite(d)) {
                            throw new JsonParseException("val [" + val + "] is not a valid number.");
                        }
                        return new JsonValue(d);
                    }
                    catch (NumberFormatException ignore) {
                        throw new JsonParseException("val [" + val + "] is not a valid number.");
                    }
                }
            }
            if (initial == '0' && val.length() > 1) {
                at1 = val.charAt(1);
                if (at1 >= '0' && at1 <= '9') {
                    throw new JsonParseException("val [" + val + "] is not a valid number.");
                }
            } else if (initial == '-' && val.length() > 2) {
                at1 = val.charAt(1);
                char at2 = val.charAt(2);
                if (at1 == '0' && at2 >= '0' && at2 <= '9') {
                    throw new JsonParseException("val [" + val + "] is not a valid number.");
                }
            }
            if ((bi = new BigInteger(val)).bitLength() <= 31) {
                return new JsonValue(bi.intValue());
            }
            if (bi.bitLength() <= 63) {
                return new JsonValue(bi.longValue());
            }
            return new JsonValue(bi);
        }
        throw new JsonParseException("val [" + val + "] is not a valid number.");
    }

    static boolean isDecimalNotation(String val) {
        return val.indexOf(46) > -1 || val.indexOf(101) > -1 || val.indexOf(69) > -1 || "-0".equals(val);
    }

    public static enum Option {
        KEEP_NULLS;

    }
}

