/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.Encoding;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonWriteUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JsonValue
implements JsonSerializable {
    private static final char QUOTE = '\"';
    private static final char COMMA = ',';
    private static final String NULL_STR = "null";
    public static final JsonValue NULL = new JsonValue();
    public static final JsonValue TRUE = new JsonValue(true);
    public static final JsonValue FALSE = new JsonValue(false);
    public static final JsonValue EMPTY_MAP = new JsonValue(Collections.unmodifiableMap(new HashMap()));
    public static final JsonValue EMPTY_ARRAY = new JsonValue(Collections.unmodifiableList(new ArrayList()));
    public final String string;
    public final Boolean bool;
    public final Integer i;
    public final Long l;
    public final Double d;
    public final Float f;
    public final BigDecimal bd;
    public final BigInteger bi;
    public final Map<String, JsonValue> map;
    public final List<JsonValue> array;
    public final Type type;
    public final Object object;
    public final Number number;
    public final List<String> mapOrder;

    public JsonValue() {
        this(null, null, null, null, null, null, null, null, null, null);
    }

    public JsonValue(String string) {
        this(string, null, null, null, null, null, null, null, null, null);
    }

    public JsonValue(char c) {
        this("" + c, null, null, null, null, null, null, null, null, null);
    }

    public JsonValue(Boolean bool) {
        this(null, bool, null, null, null, null, null, null, null, null);
    }

    public JsonValue(int i) {
        this(null, null, i, null, null, null, null, null, null, null);
    }

    public JsonValue(long l) {
        this(null, null, null, l, null, null, null, null, null, null);
    }

    public JsonValue(double d) {
        this(null, null, null, null, d, null, null, null, null, null);
    }

    public JsonValue(float f) {
        this(null, null, null, null, null, Float.valueOf(f), null, null, null, null);
    }

    public JsonValue(BigDecimal bd) {
        this(null, null, null, null, null, null, bd, null, null, null);
    }

    public JsonValue(BigInteger bi) {
        this(null, null, null, null, null, null, null, bi, null, null);
    }

    public JsonValue(Map<String, JsonValue> map) {
        this(null, null, null, null, null, null, null, null, map, null);
    }

    public JsonValue(List<JsonValue> list) {
        this(null, null, null, null, null, null, null, null, null, list);
    }

    public JsonValue(JsonValue[] values) {
        this(null, null, null, null, null, null, null, null, null, values == null ? null : Arrays.asList(values));
    }

    private JsonValue(String string, Boolean bool, Integer i, Long l, Double d, Float f, BigDecimal bd, BigInteger bi, Map<String, JsonValue> map, List<JsonValue> array) {
        this.map = map;
        this.mapOrder = new ArrayList<String>();
        this.array = array;
        this.string = string;
        this.bool = bool;
        this.i = i;
        this.l = l;
        this.d = d;
        this.f = f;
        this.bd = bd;
        this.bi = bi;
        if (i != null) {
            this.type = Type.INTEGER;
            this.number = i;
            this.object = this.number;
        } else if (l != null) {
            this.type = Type.LONG;
            this.number = l;
            this.object = this.number;
        } else if (d != null) {
            this.type = Type.DOUBLE;
            this.number = this.d;
            this.object = this.number;
        } else if (f != null) {
            this.type = Type.FLOAT;
            this.number = this.f;
            this.object = this.number;
        } else if (bd != null) {
            this.type = Type.BIG_DECIMAL;
            this.number = this.bd;
            this.object = this.number;
        } else if (bi != null) {
            this.type = Type.BIG_INTEGER;
            this.number = this.bi;
            this.object = this.number;
        } else {
            this.number = null;
            if (map != null) {
                this.type = Type.MAP;
                this.object = map;
            } else if (string != null) {
                this.type = Type.STRING;
                this.object = string;
            } else if (bool != null) {
                this.type = Type.BOOL;
                this.object = bool;
            } else if (array != null) {
                this.type = Type.ARRAY;
                this.object = array;
            } else {
                this.type = Type.NULL;
                this.object = null;
            }
        }
    }

    public String toString(Class<?> c) {
        return this.toString(c.getSimpleName());
    }

    public String toString(String key) {
        return '\"' + key + '\"' + ":" + this.toJson();
    }

    public String toString() {
        return this.toJson();
    }

    @Override
    public JsonValue toJsonValue() {
        return this;
    }

    @Override
    public String toJson() {
        switch (this.type) {
            case STRING: {
                return this.valueString(this.string);
            }
            case BOOL: {
                return this.valueString(this.bool);
            }
            case MAP: {
                return this.valueString(this.map);
            }
            case ARRAY: {
                return this.valueString(this.array);
            }
            case INTEGER: {
                return this.i.toString();
            }
            case LONG: {
                return this.l.toString();
            }
            case DOUBLE: {
                return this.d.toString();
            }
            case FLOAT: {
                return this.f.toString();
            }
            case BIG_DECIMAL: {
                return this.bd.toString();
            }
            case BIG_INTEGER: {
                return this.bi.toString();
            }
        }
        return NULL_STR;
    }

    private String valueString(String s) {
        return '\"' + Encoding.jsonEncode(s) + '\"';
    }

    private String valueString(boolean b) {
        return Boolean.toString(b).toLowerCase();
    }

    private String valueString(Map<String, JsonValue> map) {
        StringBuilder sbo = new StringBuilder("{");
        if (!this.mapOrder.isEmpty()) {
            for (String key : this.mapOrder) {
                JsonWriteUtils.addField(sbo, key, map.get(key));
            }
        } else {
            for (String key : map.keySet()) {
                JsonWriteUtils.addField(sbo, key, map.get(key));
            }
        }
        return JsonWriteUtils.endJson(sbo).toString();
    }

    private String valueString(List<JsonValue> list) {
        StringBuilder sba = JsonWriteUtils.beginArray();
        for (JsonValue v : list) {
            sba.append(v.toJson());
            sba.append(',');
        }
        return JsonWriteUtils.endArray(sba).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonValue jsonValue = (JsonValue)o;
        if (this.type != jsonValue.type) {
            return false;
        }
        if (!Objects.equals(this.map, jsonValue.map)) {
            return false;
        }
        if (!Objects.equals(this.array, jsonValue.array)) {
            return false;
        }
        if (!Objects.equals(this.string, jsonValue.string)) {
            return false;
        }
        if (!Objects.equals(this.bool, jsonValue.bool)) {
            return false;
        }
        if (!Objects.equals(this.i, jsonValue.i)) {
            return false;
        }
        if (!Objects.equals(this.l, jsonValue.l)) {
            return false;
        }
        if (!Objects.equals(this.d, jsonValue.d)) {
            return false;
        }
        if (!Objects.equals(this.f, jsonValue.f)) {
            return false;
        }
        if (!Objects.equals(this.bd, jsonValue.bd)) {
            return false;
        }
        return Objects.equals(this.bi, jsonValue.bi);
    }

    public int hashCode() {
        int result = this.map != null ? this.map.hashCode() : 0;
        result = 31 * result + (this.array != null ? this.array.hashCode() : 0);
        result = 31 * result + (this.string != null ? this.string.hashCode() : 0);
        result = 31 * result + (this.bool != null ? this.bool.hashCode() : 0);
        result = 31 * result + (this.i != null ? this.i.hashCode() : 0);
        result = 31 * result + (this.l != null ? this.l.hashCode() : 0);
        result = 31 * result + (this.d != null ? this.d.hashCode() : 0);
        result = 31 * result + (this.f != null ? this.f.hashCode() : 0);
        result = 31 * result + (this.bd != null ? this.bd.hashCode() : 0);
        result = 31 * result + (this.bi != null ? this.bi.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public static enum Type {
        STRING,
        BOOL,
        INTEGER,
        LONG,
        DOUBLE,
        FLOAT,
        BIG_DECIMAL,
        BIG_INTEGER,
        MAP,
        ARRAY,
        NULL;

    }
}

