/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class JsonValueUtils {
    private JsonValueUtils() {
    }

    public static <T> T read(JsonValue jsonValue, String key, JsonValueSupplier<T> valueSupplier) {
        JsonValue v = jsonValue == null || jsonValue.map == null ? null : jsonValue.map.get(key);
        return valueSupplier.get(v);
    }

    public static JsonValue readValue(JsonValue jsonValue, String key) {
        return JsonValueUtils.read(jsonValue, key, v -> v);
    }

    public static JsonValue readObject(JsonValue jsonValue, String key) {
        return JsonValueUtils.read(jsonValue, key, v -> v == null ? JsonValue.EMPTY_MAP : v);
    }

    public static List<JsonValue> readArray(JsonValue jsonValue, String key) {
        return JsonValueUtils.read(jsonValue, key, v -> v == null ? JsonValue.EMPTY_ARRAY.array : v.array);
    }

    public static Map<String, String> readStringStringMap(JsonValue jv, String key) {
        JsonValue o = JsonValueUtils.readObject(jv, key);
        if (o.type == JsonValue.Type.MAP && !o.map.isEmpty()) {
            HashMap<String, String> temp = new HashMap<String, String>();
            for (String k : o.map.keySet()) {
                String value = JsonValueUtils.readString(o, k);
                if (value == null) continue;
                temp.put(k, value);
            }
            return temp.isEmpty() ? null : temp;
        }
        return null;
    }

    public static String readString(JsonValue jsonValue, String key) {
        return JsonValueUtils.read(jsonValue, key, v -> v == null ? null : v.string);
    }

    public static String readString(JsonValue jsonValue, String key, String dflt) {
        return JsonValueUtils.read(jsonValue, key, v -> v == null ? dflt : v.string);
    }

    public static ZonedDateTime readDate(JsonValue jsonValue, String key) {
        return JsonValueUtils.read(jsonValue, key, v -> v == null || v.string == null ? null : DateTimeUtils.parseDateTimeThrowParseError(v.string));
    }

    public static Integer readInteger(JsonValue jsonValue, String key) {
        return JsonValueUtils.read(jsonValue, key, v -> v == null ? null : JsonValueUtils.getInteger(v));
    }

    public static int readInteger(JsonValue jsonValue, String key, int dflt) {
        return JsonValueUtils.read(jsonValue, key, v -> {
            Integer i;
            if (v != null && (i = JsonValueUtils.getInteger(v)) != null) {
                return i;
            }
            return dflt;
        });
    }

    public static Long readLong(JsonValue jsonValue, String key) {
        return JsonValueUtils.read(jsonValue, key, v -> v == null ? null : JsonValueUtils.getLong(v));
    }

    public static long readLong(JsonValue jsonValue, String key, long dflt) {
        return JsonValueUtils.read(jsonValue, key, v -> {
            Long l;
            if (v != null && (l = JsonValueUtils.getLong(v)) != null) {
                return l;
            }
            return dflt;
        });
    }

    public static boolean readBoolean(JsonValue jsonValue, String key) {
        return JsonValueUtils.readBoolean(jsonValue, key, false);
    }

    public static Boolean readBoolean(JsonValue jsonValue, String key, Boolean dflt) {
        return JsonValueUtils.read(jsonValue, key, v -> v == null || v.bool == null ? dflt : v.bool);
    }

    public static Duration readNanos(JsonValue jsonValue, String key) {
        Long l = JsonValueUtils.readLong(jsonValue, key);
        return l == null ? null : Duration.ofNanos(l);
    }

    public static Duration readNanos(JsonValue jsonValue, String key, Duration dflt) {
        Long l = JsonValueUtils.readLong(jsonValue, key);
        return l == null ? dflt : Duration.ofNanos(l);
    }

    public static <T> List<T> listOf(JsonValue v, Function<JsonValue, T> provider) {
        ArrayList<T> list = new ArrayList<T>();
        if (v != null && v.array != null) {
            for (JsonValue jv : v.array) {
                T t = provider.apply(jv);
                if (t == null) continue;
                list.add(t);
            }
        }
        return list;
    }

    public static <T> List<T> optionalListOf(JsonValue v, Function<JsonValue, T> provider) {
        List<T> list = JsonValueUtils.listOf(v, provider);
        return list.isEmpty() ? null : list;
    }

    public static List<String> readStringList(JsonValue jsonValue, String key) {
        return JsonValueUtils.read(jsonValue, key, v -> JsonValueUtils.listOf(v, jv -> jv.string));
    }

    public static List<String> readStringListIgnoreEmpty(JsonValue jsonValue, String key) {
        return JsonValueUtils.read(jsonValue, key, v -> JsonValueUtils.listOf(v, jv -> {
            String s;
            if (jv.string != null && !(s = jv.string.trim()).isEmpty()) {
                return s;
            }
            return null;
        }));
    }

    public static List<String> readOptionalStringList(JsonValue jsonValue, String key) {
        return JsonValueUtils.read(jsonValue, key, v -> JsonValueUtils.optionalListOf(v, jv -> jv.string));
    }

    public static List<Long> readLongList(JsonValue jsonValue, String key) {
        return JsonValueUtils.read(jsonValue, key, v -> JsonValueUtils.listOf(v, JsonValueUtils::getLong));
    }

    public static List<Duration> readNanosList(JsonValue jsonValue, String key) {
        return JsonValueUtils.readNanosList(jsonValue, key, false);
    }

    public static List<Duration> readNanosList(JsonValue jsonValue, String key, boolean nullIfEmpty) {
        List list = JsonValueUtils.read(jsonValue, key, v -> JsonValueUtils.listOf(v, vv -> {
            Long l = JsonValueUtils.getLong(vv);
            return l == null ? null : Duration.ofNanos(l);
        }));
        return list.isEmpty() && nullIfEmpty ? null : list;
    }

    public static byte[] readBytes(JsonValue jsonValue, String key) {
        String s = JsonValueUtils.readString(jsonValue, key);
        return s == null ? null : s.getBytes(StandardCharsets.US_ASCII);
    }

    public static byte[] readBase64(JsonValue jsonValue, String key) {
        String b64 = JsonValueUtils.readString(jsonValue, key);
        return b64 == null ? null : Base64.getDecoder().decode(b64);
    }

    public static Integer getInteger(JsonValue v) {
        if (v.i != null) {
            return v.i;
        }
        if (v.l != null && v.l <= Integer.MAX_VALUE && v.l >= Integer.MIN_VALUE) {
            return v.l.intValue();
        }
        return null;
    }

    public static Long getLong(JsonValue v) {
        return v.l != null ? v.l : (v.i != null ? Long.valueOf(v.i.intValue()) : null);
    }

    public static long getLong(JsonValue v, long dflt) {
        return v.l != null ? v.l : (v.i != null ? (long)v.i.intValue() : dflt);
    }

    public static JsonValue instance(Duration d) {
        return new JsonValue(d.toNanos());
    }

    public static JsonValue instance(Collection list) {
        JsonValue v = new JsonValue(new ArrayList<JsonValue>());
        for (Object o : list) {
            v.array.add(JsonValueUtils.toJsonValue(o));
        }
        return v;
    }

    public static JsonValue instance(Map map) {
        JsonValue v = new JsonValue(new HashMap<String, JsonValue>());
        for (Object key : map.keySet()) {
            v.map.put(key.toString(), JsonValueUtils.toJsonValue(map.get(key)));
        }
        return v;
    }

    public static JsonValue toJsonValue(Object o) {
        if (o == null) {
            return JsonValue.NULL;
        }
        if (o instanceof JsonValue) {
            return (JsonValue)o;
        }
        if (o instanceof JsonSerializable) {
            return ((JsonSerializable)o).toJsonValue();
        }
        if (o instanceof Map) {
            return new JsonValue((Map)o);
        }
        if (o instanceof List) {
            return new JsonValue((List)o);
        }
        if (o instanceof Set) {
            return new JsonValue(new ArrayList<JsonValue>((Set)o));
        }
        if (o instanceof String) {
            String s = ((String)o).trim();
            return s.length() == 0 ? new JsonValue() : new JsonValue(s);
        }
        if (o instanceof Boolean) {
            return new JsonValue((Boolean)o);
        }
        if (o instanceof Integer) {
            return new JsonValue((Integer)o);
        }
        if (o instanceof Long) {
            return new JsonValue((Long)o);
        }
        if (o instanceof Double) {
            return new JsonValue((Double)o);
        }
        if (o instanceof Float) {
            return new JsonValue(((Float)o).floatValue());
        }
        if (o instanceof BigDecimal) {
            return new JsonValue((BigDecimal)o);
        }
        if (o instanceof BigInteger) {
            return new JsonValue((BigInteger)o);
        }
        return new JsonValue(o.toString());
    }

    public static MapBuilder mapBuilder() {
        return new MapBuilder();
    }

    public static ArrayBuilder arrayBuilder() {
        return new ArrayBuilder();
    }

    public static class ArrayBuilder
    implements JsonSerializable {
        public JsonValue jv = new JsonValue(new ArrayList<JsonValue>());

        public ArrayBuilder add(Object o) {
            if (o != null) {
                JsonValue vv = JsonValueUtils.toJsonValue(o);
                if (vv.type != JsonValue.Type.NULL) {
                    this.jv.array.add(JsonValueUtils.toJsonValue(o));
                }
            }
            return this;
        }

        @Override
        public String toJson() {
            return this.jv.toJson();
        }

        @Override
        public JsonValue toJsonValue() {
            return this.jv;
        }

        @Deprecated
        public JsonValue getJsonValue() {
            return this.jv;
        }
    }

    public static class MapBuilder
    implements JsonSerializable {
        public JsonValue jv;

        public MapBuilder() {
            this.jv = new JsonValue(new HashMap<String, JsonValue>());
        }

        public MapBuilder(JsonValue jv) {
            this.jv = jv;
        }

        public MapBuilder put(String s, Object o) {
            if (o != null) {
                JsonValue vv = JsonValueUtils.toJsonValue(o);
                if (vv.type != JsonValue.Type.NULL) {
                    this.jv.map.put(s, vv);
                    this.jv.mapOrder.add(s);
                }
            }
            return this;
        }

        public MapBuilder put(String s, Map<String, String> stringMap) {
            if (stringMap != null) {
                MapBuilder mb = new MapBuilder();
                for (String key : stringMap.keySet()) {
                    mb.put(key, stringMap.get(key));
                }
                this.jv.map.put(s, mb.jv);
                this.jv.mapOrder.add(s);
            }
            return this;
        }

        @Override
        public String toJson() {
            return this.jv.toJson();
        }

        @Override
        public JsonValue toJsonValue() {
            return this.jv;
        }
    }

    public static interface JsonValueSupplier<T> {
        public T get(JsonValue var1);
    }
}

