/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.Encoding;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonValueUtils;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class JsonWriteUtils {
    public static final String Q = "\"";
    public static final String QCOLONQ = "\":\"";
    public static final String QCOLON = "\":";
    public static final String QCOMMA = "\",";
    public static final String COMMA = ",";
    private static final String INDENT = "                                        ";

    private JsonWriteUtils() {
    }

    public static StringBuilder beginJson() {
        return new StringBuilder("{");
    }

    public static StringBuilder beginArray() {
        return new StringBuilder("[");
    }

    public static StringBuilder beginJsonPrefixed(String prefix) {
        return prefix == null ? JsonWriteUtils.beginJson() : new StringBuilder(prefix).append('{');
    }

    public static StringBuilder endJson(StringBuilder sb) {
        int lastIndex = sb.length() - 1;
        if (sb.charAt(lastIndex) == ',') {
            sb.setCharAt(lastIndex, '}');
            return sb;
        }
        sb.append("}");
        return sb;
    }

    public static StringBuilder endArray(StringBuilder sb) {
        int lastIndex = sb.length() - 1;
        if (sb.charAt(lastIndex) == ',') {
            sb.setCharAt(lastIndex, ']');
            return sb;
        }
        sb.append("]");
        return sb;
    }

    public static StringBuilder beginFormattedJson() {
        return new StringBuilder("{\n    ");
    }

    public static String endFormattedJson(StringBuilder sb) {
        sb.setLength(sb.length() - 1);
        sb.append("\n}");
        return sb.toString().replaceAll(COMMA, ",\n    ");
    }

    public static void addRawJson(StringBuilder sb, String fname, String json) {
        if (json != null && !json.isEmpty()) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON);
            sb.append(json);
            sb.append(COMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, String value) {
        if (value != null && !value.isEmpty()) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLONQ);
            Encoding.jsonEncode(sb, value);
            sb.append(QCOMMA);
        }
    }

    public static void addFieldEvenEmpty(StringBuilder sb, String fname, String value) {
        if (value == null) {
            value = "";
        }
        sb.append(Q);
        Encoding.jsonEncode(sb, fname);
        sb.append(QCOLONQ);
        Encoding.jsonEncode(sb, value);
        sb.append(QCOMMA);
    }

    public static void addField(StringBuilder sb, String fname, Boolean value) {
        if (value != null) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value != false ? "true" : "false").append(COMMA);
        }
    }

    public static void addFldWhenTrue(StringBuilder sb, String fname, Boolean value) {
        if (value != null && value.booleanValue()) {
            JsonWriteUtils.addField(sb, fname, true);
        }
    }

    public static void addField(StringBuilder sb, String fname, Integer value) {
        if (value != null && value >= 0) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldWhenGtZero(StringBuilder sb, String fname, Integer value) {
        if (value != null && value > 0) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, Long value) {
        if (value != null && value >= 0L) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldWhenGtZero(StringBuilder sb, String fname, Long value) {
        if (value != null && value > 0L) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldWhenGteMinusOne(StringBuilder sb, String fname, Long value) {
        if (value != null && value >= -1L) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldWhenGreaterThan(StringBuilder sb, String fname, Long value, long gt) {
        if (value != null && value > gt) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value).append(COMMA);
        }
    }

    public static void addFieldAsNanos(StringBuilder sb, String fname, Duration value) {
        if (value != null && !value.isZero() && !value.isNegative()) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value.toNanos()).append(COMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, JsonSerializable value) {
        if (value != null) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLON).append(value.toJson()).append(COMMA);
        }
    }

    public static void addField(StringBuilder sb, String fname, Map<String, String> map) {
        if (map != null && !map.isEmpty()) {
            JsonWriteUtils.addField(sb, fname, JsonValueUtils.instance(map));
        }
    }

    public static void addEnumWhenNot(StringBuilder sb, String fname, Enum e, Enum dontAddIfThis) {
        if (e != null && e != dontAddIfThis) {
            JsonWriteUtils.addField(sb, fname, e.toString());
        }
    }

    public static <T> void _addList(StringBuilder sb, String fname, List<T> list, ListAdder<T> adder) {
        sb.append(Q);
        Encoding.jsonEncode(sb, fname);
        sb.append("\":[");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(COMMA);
            }
            adder.append(sb, list.get(i));
        }
        sb.append("],");
    }

    public static void addStrings(StringBuilder sb, String fname, String[] strings) {
        if (strings != null && strings.length > 0) {
            JsonWriteUtils._addStrings(sb, fname, Arrays.asList(strings));
        }
    }

    public static void addStrings(StringBuilder sb, String fname, List<String> strings) {
        if (strings != null && !strings.isEmpty()) {
            JsonWriteUtils._addStrings(sb, fname, strings);
        }
    }

    private static void _addStrings(StringBuilder sb, String fname, List<String> strings) {
        JsonWriteUtils._addList(sb, fname, strings, (sbs, s) -> {
            sb.append(Q);
            Encoding.jsonEncode(sb, s);
            sb.append(Q);
        });
    }

    public static void addJsons(StringBuilder sb, String fname, List<? extends JsonSerializable> jsons) {
        if (jsons != null && !jsons.isEmpty()) {
            JsonWriteUtils._addList(sb, fname, jsons, (sbs, s) -> sbs.append(s.toJson()));
        }
    }

    public static void addDurations(StringBuilder sb, String fname, List<Duration> durations) {
        if (durations != null && !durations.isEmpty()) {
            JsonWriteUtils._addList(sb, fname, durations, (sbs, dur) -> sbs.append(dur.toNanos()));
        }
    }

    public static void addField(StringBuilder sb, String fname, ZonedDateTime zonedDateTime) {
        if (zonedDateTime != null && !DateTimeUtils.DEFAULT_TIME.equals(zonedDateTime)) {
            sb.append(Q);
            Encoding.jsonEncode(sb, fname);
            sb.append(QCOLONQ).append(DateTimeUtils.toRfc3339(zonedDateTime)).append(QCOMMA);
        }
    }

    public static String toKey(Class<?> c) {
        return Q + c.getSimpleName() + QCOLON;
    }

    private static String indent(int level) {
        return level == 0 ? "" : INDENT.substring(0, level * 4);
    }

    public static String getFormatted(Object o) {
        StringBuilder sb = new StringBuilder();
        int level = 0;
        int arrayLevel = 0;
        boolean lastWasClose = false;
        boolean indentNext = true;
        String indent = "";
        String s = o.toString();
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c == '{') {
                if (arrayLevel > 0 && lastWasClose) {
                    sb.append(indent);
                }
                sb.append(c).append('\n');
                indent = JsonWriteUtils.indent(++level);
                indentNext = true;
                lastWasClose = false;
                continue;
            }
            if (c == '}') {
                indent = JsonWriteUtils.indent(--level);
                sb.append('\n').append(indent).append(c);
                lastWasClose = true;
                continue;
            }
            if (c == ',') {
                sb.append(",\n");
                indentNext = true;
                continue;
            }
            if (c == '[') {
                ++arrayLevel;
            } else if (c == ']') {
                --arrayLevel;
            }
            if (indentNext) {
                if (c != ' ') {
                    sb.append(indent).append(c);
                    indentNext = false;
                }
            } else {
                sb.append(c);
            }
            lastWasClose = lastWasClose && Character.isWhitespace(c);
        }
        return sb.toString();
    }

    public static void printFormatted(Object o) {
        System.out.println(JsonWriteUtils.getFormatted(o));
    }

    public static Long safeParseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (Exception e1) {
            try {
                return Long.parseUnsignedLong(s);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static long safeParseLong(String s, long dflt) {
        Long l = JsonWriteUtils.safeParseLong(s);
        return l == null ? dflt : l;
    }

    public static interface ListAdder<T> {
        public void append(StringBuilder var1, T var2);
    }
}

