/*
 * Decompiled with CFR 0.152.
 */
package nats.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

final class NatsOutputLogger
implements Runnable {
    private final Logger logger;
    private final BufferedReader reader;
    private final int port;

    private NatsOutputLogger(Logger logger, Process process, int port) {
        this.logger = logger;
        this.port = port;
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
    }

    private void logLine(String line) {
        this.logger.logp(Level.INFO, Thread.currentThread().getName(), String.valueOf(this.port), line);
    }

    @Override
    public void run() {
        try {
            try {
                this.reader.lines().forEach(this::logLine);
            }
            catch (UncheckedIOException e) {
                this.logger.warning("while reading output " + e);
            }
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                this.logger.warning("caught i/o exception closing reader" + e);
            }
        }
    }

    static void logOutput(Logger logger, Process process, String processName, int port) {
        String threadName = (NatsOutputLogger.isNotBlank(processName) ? processName : "unknown") + ":" + NatsOutputLogger.processId(process);
        Thread t = new Thread(new NatsOutputLogger(logger, process, port));
        t.setName(threadName);
        t.setDaemon(true);
        t.start();
    }

    private static String processId(Process process) {
        try {
            return String.format("pid(%s)", MethodHandles.lookup().findVirtual(Process.class, "pid", MethodType.methodType(Long.TYPE)).invoke(process));
        }
        catch (Throwable throwable) {
            try {
                Field pid = process.getClass().getDeclaredField("pid");
                pid.setAccessible(true);
                return String.format("pid(%s)", pid.getInt(process));
            }
            catch (Exception exception) {
                return String.format("id(%s)", process.hashCode());
            }
        }
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen = cs.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isNotBlank(CharSequence cs) {
        return !NatsOutputLogger.isBlank(cs);
    }
}

