/*
 * Decompiled with CFR 0.152.
 */
package nats.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.util.ArrayList;

public class NatsRunnerUtils {
    public static final String NATS_SERVER_PATH_ENV = "nats_server_path";
    public static final String DEFAULT_NATS_SERVER = "nats-server";
    public static final String CONFIG_FILE_OPTION_NAME = "--config";
    public static final String VERSION_OPTION = "--version";
    public static final String DEBUG_OPTION = "-DV";
    public static final String JETSTREAM_OPTION = "-js";
    public static final String CONF_FILE_PREFIX = "nats_java_test";
    public static final String CONF_FILE_EXT = ".conf";
    public static final String PORT_REGEX = "port: (\\d+)";
    public static final String PORT_PROPERTY = "port: ";
    private static String SERVER_PATH = null;

    public static String getURIForPort(int port) {
        return "nats://localhost:" + port;
    }

    public static void setServerPath(String serverPath) {
        SERVER_PATH = serverPath;
    }

    public static void clearServerPath() {
        SERVER_PATH = null;
    }

    public static String getResolvedServerPath() {
        String serverPath = System.getenv(NATS_SERVER_PATH_ENV);
        if (serverPath == null) {
            serverPath = SERVER_PATH == null ? DEFAULT_NATS_SERVER : SERVER_PATH;
        }
        return serverPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int nextPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            while (!socket.isBound()) {
                Thread.sleep(50L);
            }
            int n = socket.getLocalPort();
            return n;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread interrupted", e);
        }
    }

    public static String getNatsServerVersionString() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(NatsRunnerUtils.getResolvedServerPath());
        cmd.add(VERSION_OPTION);
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            Process process = pb.start();
            if (0 != process.waitFor()) {
                throw new IllegalStateException(String.format("Process %s failed", pb.command()));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            ArrayList<String> lines = new ArrayList<String>();
            String line = "";
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            if (lines.size() > 0) {
                return (String)lines.get(0);
            }
            return null;
        }
        catch (Exception exp) {
            return null;
        }
    }
}

