/*
 * Decompiled with CFR 0.152.
 */
package nats.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nats.io.NatsOutputLogger;
import nats.io.NatsRunnerUtils;

public class NatsServerRunner
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(NatsServerRunner.class.getName());
    private final int _port;
    private final File configFile;
    private Process process;
    private final String cmdLine;

    public NatsServerRunner() throws IOException {
        this(0, false, false, null, null, null);
    }

    public NatsServerRunner(boolean debug) throws IOException {
        this(0, debug, false, null, null, null);
    }

    public NatsServerRunner(boolean debug, boolean jetstream) throws IOException {
        this(0, debug, jetstream, null, null, null);
    }

    public NatsServerRunner(int port, boolean debug) throws IOException {
        this(port, debug, false, null, null, null);
    }

    public NatsServerRunner(int port, boolean debug, boolean jetstream) throws IOException {
        this(port, debug, jetstream, null, null, null);
    }

    public NatsServerRunner(String configFilePath, boolean debug) throws IOException {
        this(0, debug, false, configFilePath, null, null);
    }

    public NatsServerRunner(String configFilePath, boolean debug, boolean jetstream) throws IOException {
        this(0, debug, jetstream, configFilePath, null, null);
    }

    public NatsServerRunner(String configFilePath, String[] configInserts, int port, boolean debug) throws IOException {
        this(port, debug, false, configFilePath, configInserts, null);
    }

    public NatsServerRunner(String configFilePath, int port, boolean debug) throws IOException {
        this(port, debug, false, configFilePath, null, null);
    }

    public NatsServerRunner(String[] customArgs) throws IOException {
        this(0, false, false, null, null, customArgs);
    }

    public NatsServerRunner(String[] customArgs, boolean debug) throws IOException {
        this(0, debug, false, null, null, customArgs);
    }

    public NatsServerRunner(String[] customArgs, boolean debug, boolean jetstream) throws IOException {
        this(0, debug, jetstream, null, null, customArgs);
    }

    public NatsServerRunner(String[] customArgs, int port, boolean debug) throws IOException {
        this(port, debug, false, null, null, customArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NatsServerRunner(int port, boolean debug, boolean jetstream, String configFilePath, String[] configInserts, String[] customArgs) throws IOException {
        this._port = port <= 0 ? NatsRunnerUtils.nextPort() : port;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(NatsRunnerUtils.getResolvedServerPath());
        try {
            this.configFile = File.createTempFile("nats_java_test", ".conf");
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));
            if (configFilePath == null || this.processSuppliedConfigFile(writer, configFilePath)) {
                this.writePortLine(writer, this._port);
            }
            if (configInserts != null) {
                for (String s : configInserts) {
                    this.writeLine(writer, s);
                }
            }
            writer.flush();
            writer.close();
            cmd.add("--config");
            cmd.add(this.configFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            LOGGER.severe("%%% Error creating config file: " + ioe);
            throw ioe;
        }
        if (jetstream) {
            cmd.add("-js");
        }
        if (customArgs != null) {
            cmd.addAll(Arrays.asList(customArgs));
        }
        if (debug) {
            cmd.add("-DV");
        }
        this.cmdLine = String.join((CharSequence)" ", cmd);
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            pb.redirectError(ProcessBuilder.Redirect.PIPE);
            pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
            LOGGER.info("%%% Starting [" + this.cmdLine + "] with redirected IO");
            this.process = pb.start();
            NatsOutputLogger.logOutput(LOGGER, this.process, "nats-server", this._port);
            int tries = 10;
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (!this.process.isAlive() && --tries > 0);
            InetSocketAddress addr = new InetSocketAddress("localhost", this._port);
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(true);
            boolean scanning = true;
            while (scanning) {
                try {
                    socketChannel.connect(addr);
                }
                finally {
                    socketChannel.close();
                }
                scanning = false;
            }
            LOGGER.info("%%% Started [" + this.cmdLine + "]");
        }
        catch (IOException ex) {
            LOGGER.info("%%% Failed to start [" + this.cmdLine + "] with message:");
            LOGGER.info("\t" + ex.getMessage());
            LOGGER.info("%%% Make sure that the nats-server is installed and in your PATH.");
            LOGGER.info("%%% See https://github.com/nats-io/nats-server for information on installation");
            throw new IllegalStateException("Failed to run [" + this.cmdLine + "]");
        }
    }

    private boolean processSuppliedConfigFile(BufferedWriter writer, String configFilePath) throws IOException {
        Pattern portPattern = Pattern.compile("port: (\\d+)");
        Matcher portMatcher = portPattern.matcher("");
        BufferedReader reader = new BufferedReader(new FileReader(configFilePath));
        boolean needsPortLine = true;
        String line = reader.readLine();
        while (line != null) {
            portMatcher.reset(line);
            if (portMatcher.find()) {
                this.writeLine(writer, line.replace(portMatcher.group(1), String.valueOf(this._port)));
                needsPortLine = false;
            } else {
                this.writeLine(writer, line);
            }
            line = reader.readLine();
        }
        reader.close();
        return needsPortLine;
    }

    private void writePortLine(BufferedWriter writer, int port) throws IOException {
        this.writeLine(writer, "port: " + port);
    }

    private void writeLine(BufferedWriter writer, String line) throws IOException {
        writer.write(line);
        writer.write("\n");
    }

    public int getPort() {
        return this._port;
    }

    public String getConfigFile() {
        return this.configFile.getAbsolutePath();
    }

    public String getURI() {
        return NatsRunnerUtils.getURIForPort(this._port);
    }

    public String getCmdLine() {
        return this.cmdLine;
    }

    public void shutdown(boolean wait) throws InterruptedException {
        if (this.process != null) {
            this.process.destroy();
            LOGGER.info("%%% Shut down [" + this.cmdLine + "]");
            if (wait) {
                this.process.waitFor();
            }
            this.process = null;
        }
    }

    public void shutdown() throws InterruptedException {
        this.shutdown(true);
    }

    @Override
    public void close() throws InterruptedException {
        this.shutdown();
    }
}

