/*
 * Decompiled with CFR 0.152.
 */
package nats.io;

import java.nio.file.Path;

public class ClusterNode {
    public final String clusterName;
    public final String serverName;
    public final int port;
    public final int listen;
    public final String host;
    public final Integer monitor;
    public final Path jsStoreDir;

    public ClusterNode(String clusterName, String serverName, int port, int listen) {
        this(clusterName, serverName, null, port, listen, null, null);
    }

    public ClusterNode(String clusterName, String serverName, int port, int listen, Integer monitor) {
        this(clusterName, serverName, null, port, listen, monitor, null);
    }

    public ClusterNode(String clusterName, String serverName, int port, int listen, Path jsStoreDir) {
        this(clusterName, serverName, null, port, listen, null, jsStoreDir);
    }

    public ClusterNode(String clusterName, String serverName, String host, int port, int listen, Integer monitor, Path jsStoreDir) {
        this.clusterName = clusterName;
        this.serverName = serverName;
        this.host = host;
        this.port = port;
        this.listen = listen;
        this.monitor = monitor;
        this.jsStoreDir = jsStoreDir;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String clusterName;
        private String serverName;
        private int port;
        private int listen;
        private String host;
        private Integer monitor;
        private Path jsStoreDir;

        public Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder listen(int listen) {
            this.listen = listen;
            return this;
        }

        public Builder monitor(Integer monitor) {
            this.monitor = monitor;
            return this;
        }

        public Builder jsStoreDir(Path jsStoreDir) {
            this.jsStoreDir = jsStoreDir;
            return this;
        }

        public ClusterNode build() {
            return new ClusterNode(this.clusterName, this.serverName, this.host, this.port, this.listen, this.monitor, this.jsStoreDir);
        }
    }
}

