/*
 * Decompiled with CFR 0.152.
 */
package nats.io;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import nats.io.Output;

public class ConsoleOutput
implements Output {
    private Level level = Level.INFO;

    protected String format(Level targetLevel, String msg) {
        return targetLevel + ": " + msg;
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public void error(Supplier<String> msgSupplier) {
        if (this.shouldShow(Level.SEVERE)) {
            System.err.println(this.format(Level.SEVERE, msgSupplier.get()));
        }
    }

    @Override
    public void error(String msg) {
        if (this.shouldShow(Level.SEVERE)) {
            System.err.println(this.format(Level.SEVERE, msg));
        }
    }

    @Override
    public void warning(Supplier<String> msgSupplier) {
        if (this.shouldShow(Level.WARNING)) {
            System.out.println(this.format(Level.WARNING, msgSupplier.get()));
        }
    }

    @Override
    public void warning(String msg) {
        if (this.shouldShow(Level.WARNING)) {
            System.out.println(this.format(Level.WARNING, msg));
        }
    }

    @Override
    public void info(Supplier<String> msgSupplier) {
        if (this.shouldShow(Level.INFO)) {
            System.out.println(this.format(Level.INFO, msgSupplier.get()));
        }
    }

    @Override
    public void info(String msg) {
        if (this.shouldShow(Level.INFO)) {
            System.out.println(this.format(Level.INFO, msg));
        }
    }

    @Override
    public boolean isLogger() {
        return false;
    }

    @Override
    public Logger getLogger() {
        return null;
    }

    protected boolean shouldShow(Level testLevel) {
        return this.level.intValue() <= testLevel.intValue() && testLevel != Level.OFF;
    }
}

