/*
 * Decompiled with CFR 0.152.
 */
package nats.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import nats.io.Output;

final class NatsOutputLogger
implements Runnable {
    private final Output output;
    private final BufferedReader reader;
    private final List<String> startupLines;
    private boolean inStartupPhase;

    private NatsOutputLogger(Output output, Process process) {
        this.output = output;
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        this.startupLines = new ArrayList<String>();
        this.inStartupPhase = true;
    }

    public void endStartupPhase() {
        this.inStartupPhase = false;
    }

    public List<String> getStartupLines() {
        return this.startupLines;
    }

    public void logInfo(String line) {
        this.output.info(() -> line);
        if (this.inStartupPhase) {
            this.startupLines.add(line);
        }
    }

    @Override
    public void run() {
        try {
            try {
                this.reader.lines().forEach(this::logInfo);
            }
            catch (UncheckedIOException e) {
                this.output.warning(() -> "while reading output " + e);
            }
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                this.output.warning(() -> "caught i/o exception closing reader" + e);
            }
        }
    }

    static NatsOutputLogger logOutput(Output output, Process process, String processName) {
        String threadName = (NatsOutputLogger.isBlank(processName) ? "unknown" : processName) + ":" + NatsOutputLogger.processId(process);
        NatsOutputLogger nol = new NatsOutputLogger(output, process);
        Thread t = new Thread(nol);
        t.setName(threadName);
        t.setDaemon(true);
        t.start();
        return nol;
    }

    private static String processId(Process process) {
        try {
            return String.format("pid(%s)", MethodHandles.lookup().findVirtual(Process.class, "pid", MethodType.methodType(Long.TYPE)).invoke(process));
        }
        catch (Throwable throwable) {
            try {
                Field pid = process.getClass().getDeclaredField("pid");
                pid.setAccessible(true);
                return String.format("pid(%s)", pid.getInt(process));
            }
            catch (Exception exception) {
                return String.format("id(%s)", process.hashCode());
            }
        }
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen = cs.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

