/*
 * Decompiled with CFR 0.152.
 */
package nats.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import nats.io.ClusterInsert;
import nats.io.ClusterNode;
import nats.io.NatsServerRunner;

public abstract class NatsRunnerUtils {
    public static final String NATS_SERVER_PATH_ENV = "nats_server_path";
    public static final String DEFAULT_NATS_SERVER = "nats-server";
    public static final String CONFIG_FILE_OPTION_NAME = "--config";
    public static final String VERSION_OPTION = "--version";
    public static final String JETSTREAM_OPTION = "-js";
    public static final String CONF_FILE_PREFIX = "nats_java_test";
    public static final String CONF_FILE_EXT = ".conf";
    public static final String PORT_REGEX = "port: (\\d+)";
    public static final String PORT_MAPPED_REGEX = "port: <(\\w+)>";
    public static final String PORT_PROPERTY = "port: ";
    public static final String CONFIG_PORT_KEY = "config_port";
    public static final String USER_PORT_KEY = "user_port";
    public static final String NATS_PORT_KEY = "nats_port";
    public static final String NON_NATS_PORT_KEY = "non_nats_port";
    public static final int DEFAULT_CLUSTER_COUNT = 3;
    public static final String DEFAULT_CLUSTER_NAME = "cluster";
    public static final String DEFAULT_SERVER_NAME_PREFIX = "server";
    public static final String NATS = "nats";
    public static final String LOCALHOST = "localhost";
    public static String DEFAULT_HOST = "127.0.0.1";
    public static int DEFAULT_PORT_START = 4220;
    public static int DEFAULT_LISTEN_START = 4230;
    public static int DEFAULT_MONITOR_START = 4280;

    private NatsRunnerUtils() {
    }

    @Deprecated
    public static String getURIForPort(int port) {
        return NatsRunnerUtils.getUri(NATS, LOCALHOST, port);
    }

    public static String getNatsLocalhostUri(int port) {
        return NatsRunnerUtils.getUri(NATS, LOCALHOST, port);
    }

    public static String getNatsUri(String host, int port) {
        return NatsRunnerUtils.getUri(NATS, host, port);
    }

    public static String getLocalhostUri(String schema, int port) {
        return NatsRunnerUtils.getUri(schema, LOCALHOST, port);
    }

    public static String getUri(String schema, String host, int port) {
        return schema + "://" + host + ":" + port;
    }

    @Deprecated
    public static void setServerPath(String serverPath) {
        NatsServerRunner.setPreferredServerPath(serverPath);
    }

    @Deprecated
    public static void clearServerPath() {
        NatsServerRunner.clearPreferredServerPath();
    }

    public static String getResolvedServerPath() {
        String serverPath = NatsServerRunner.getPreferredServerPath();
        if (serverPath == null && (serverPath = System.getenv(NATS_SERVER_PATH_ENV)) == null) {
            serverPath = DEFAULT_NATS_SERVER;
        }
        return serverPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int nextPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            while (!socket.isBound()) {
                Thread.sleep(50L);
            }
            int n = socket.getLocalPort();
            return n;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Thread interrupted", e);
        }
    }

    public static String getNatsServerVersionString() {
        return NatsRunnerUtils.getNatsServerVersionString(NatsRunnerUtils.getResolvedServerPath());
    }

    public static String getNatsServerVersionString(String serverPath) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(serverPath);
        cmd.add(VERSION_OPTION);
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            Process process = pb.start();
            if (0 != process.waitFor()) {
                throw new IllegalStateException(String.format("Process %s failed", pb.command()));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            ArrayList<String> lines = new ArrayList<String>();
            String line = "";
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            if (lines.size() > 0) {
                return (String)lines.get(0);
            }
            return null;
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static List<ClusterInsert> createClusterInserts() throws IOException {
        return NatsRunnerUtils.createClusterInserts(3, DEFAULT_CLUSTER_NAME, DEFAULT_SERVER_NAME_PREFIX, false, null);
    }

    public static List<ClusterInsert> createClusterInserts(Path jsStoreDirBase) throws IOException {
        return NatsRunnerUtils.createClusterInserts(3, DEFAULT_CLUSTER_NAME, DEFAULT_SERVER_NAME_PREFIX, false, jsStoreDirBase);
    }

    public static List<ClusterInsert> createClusterInserts(int count) throws IOException {
        return NatsRunnerUtils.createClusterInserts(count, DEFAULT_CLUSTER_NAME, DEFAULT_SERVER_NAME_PREFIX, false, null);
    }

    public static List<ClusterInsert> createClusterInserts(int count, Path jsStoreDirBase) throws IOException {
        return NatsRunnerUtils.createClusterInserts(count, DEFAULT_CLUSTER_NAME, DEFAULT_SERVER_NAME_PREFIX, false, jsStoreDirBase);
    }

    public static List<ClusterInsert> createClusterInserts(int count, String clusterName, String serverNamePrefix) throws IOException {
        return NatsRunnerUtils.createClusterInserts(NatsRunnerUtils.createNodes(count, clusterName, serverNamePrefix, false, null));
    }

    public static List<ClusterInsert> createClusterInserts(int count, String clusterName, String serverNamePrefix, Path jsStoreDirBase) throws IOException {
        return NatsRunnerUtils.createClusterInserts(NatsRunnerUtils.createNodes(count, clusterName, serverNamePrefix, false, jsStoreDirBase));
    }

    public static List<ClusterInsert> createClusterInserts(int count, String clusterName, String serverNamePrefix, boolean monitor) throws IOException {
        return NatsRunnerUtils.createClusterInserts(NatsRunnerUtils.createNodes(count, clusterName, serverNamePrefix, monitor, null));
    }

    public static List<ClusterInsert> createClusterInserts(int count, String clusterName, String serverNamePrefix, boolean monitor, Path jsStoreDirBase) throws IOException {
        return NatsRunnerUtils.createClusterInserts(NatsRunnerUtils.createNodes(count, clusterName, serverNamePrefix, monitor, jsStoreDirBase));
    }

    public static void defaultHost(String defaultHost) {
        DEFAULT_HOST = defaultHost;
    }

    public static void defaultPortStart(int defaultPortStart) {
        DEFAULT_PORT_START = defaultPortStart;
    }

    public static void defaultListenStart(int defaultListenStart) {
        DEFAULT_LISTEN_START = defaultListenStart;
    }

    public static void defaultMonitorStart(int defaultMonitorStart) {
        DEFAULT_MONITOR_START = defaultMonitorStart;
    }

    public static List<ClusterNode> createNodes(int count, String clusterName, String serverNamePrefix, boolean monitor, Path jsStoreDirBase) {
        return NatsRunnerUtils.createNodes(count, clusterName, serverNamePrefix, jsStoreDirBase, DEFAULT_HOST, DEFAULT_PORT_START, DEFAULT_LISTEN_START, monitor ? Integer.valueOf(DEFAULT_MONITOR_START) : null);
    }

    public static List<ClusterNode> createNodes(int count, String clusterName, String serverNamePrefix, Path jsStoreDirBase, String host, int portStart, int listenStart, Integer monitorStart) {
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
        for (int x = 0; x < count; ++x) {
            int port = portStart + x;
            int listen = listenStart + x;
            Integer monitor = monitorStart == null ? null : Integer.valueOf(monitorStart + x);
            Path jsStoreDir = jsStoreDirBase == null ? null : Paths.get(jsStoreDirBase.toString(), "" + port);
            nodes.add(new ClusterNode(clusterName, serverNamePrefix + x, host, port, listen, monitor, jsStoreDir));
        }
        return nodes;
    }

    public static List<ClusterInsert> createClusterInserts(List<ClusterNode> nodes) {
        ArrayList<ClusterInsert> inserts = new ArrayList<ClusterInsert>();
        for (ClusterNode node : nodes) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("port:" + node.port);
            if (node.monitor != null) {
                lines.add("http:" + node.monitor);
            }
            if (node.jsStoreDir != null) {
                String dir = node.jsStoreDir.toString();
                dir = File.separatorChar == '\\' ? dir.replace("\\", "\\\\").replace("/", "\\\\") : dir.replace("\\", "/");
                lines.add("jetstream {");
                lines.add("    store_dir=" + dir);
                lines.add("}");
            }
            lines.add("server_name=" + node.serverName);
            lines.add("cluster {");
            lines.add("  name: " + node.clusterName);
            lines.add("  listen: " + node.host + ":" + node.listen);
            lines.add("  routes: [");
            for (ClusterNode routeNode : nodes) {
                if (routeNode.serverName.equals(node.serverName)) continue;
                lines.add("    nats-route://" + node.host + ":" + routeNode.listen);
            }
            lines.add("  ]");
            lines.add("}");
            inserts.add(new ClusterInsert(node, lines.toArray(new String[0])));
        }
        return inserts;
    }
}

