/*
 * Decompiled with CFR 0.152.
 */
package nats.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nats.io.DebugLevel;
import nats.io.LoggingOutput;
import nats.io.NatsOutputLogger;
import nats.io.NatsRunnerUtils;
import nats.io.NatsServerRunnerOptions;
import nats.io.NatsServerRunnerOptionsImpl;
import nats.io.Output;

public class NatsServerRunner
implements AutoCloseable {
    public static final String ERROR_NOTE_PART_1 = "Make sure that the nats-server is installed and in your PATH.";
    public static final String ERROR_NOTE_PART_2 = "See https://github.com/nats-io/nats-server for information on installation";
    public static long DEFAULT_PROCESS_CHECK_WAIT = 100L;
    public static int DEFAULT_PROCESS_CHECK_TRIES = 10;
    public static long DEFAULT_RUN_CHECK_WAIT = 100L;
    public static int DEFAULT_RUN_CHECK_TRIES = 3;
    private final String _executablePath;
    private final Output _displayOut;
    private final Map<String, Integer> _ports;
    private final File _configFile;
    private final String _cmdLine;
    private Process process;
    static final Supplier<Output> DefaultLoggingSupplier = () -> new LoggingOutput(Logger.getLogger(NatsServerRunner.class.getName()));
    private static Supplier<Output> DefaultOutputSupplier = DefaultLoggingSupplier;
    private static Level DefaultOutputLevel = Level.INFO;
    private static String PreferredServerPath = null;

    public static Builder builder() {
        return new Builder();
    }

    public NatsServerRunner() throws IOException {
        this(NatsServerRunner.builder());
    }

    public NatsServerRunner(boolean debug) throws IOException {
        this(NatsServerRunner.builder().debug(debug));
    }

    public NatsServerRunner(boolean debug, boolean jetstream) throws IOException {
        this(NatsServerRunner.builder().debug(debug).jetstream(jetstream));
    }

    public NatsServerRunner(int port, boolean debug) throws IOException {
        this(NatsServerRunner.builder().port(port).debug(debug));
    }

    public NatsServerRunner(int port, boolean debug, boolean jetstream) throws IOException {
        this(NatsServerRunner.builder().port(port).debug(debug).jetstream(jetstream));
    }

    public NatsServerRunner(String configFilePath, boolean debug) throws IOException {
        this(NatsServerRunner.builder().debug(debug).configFilePath(configFilePath));
    }

    public NatsServerRunner(String configFilePath, boolean debug, boolean jetstream) throws IOException {
        this(NatsServerRunner.builder().debug(debug).jetstream(jetstream).configFilePath(configFilePath));
    }

    public NatsServerRunner(String configFilePath, String[] configInserts, int port, boolean debug) throws IOException {
        this(NatsServerRunner.builder().port(port).debug(debug).configFilePath(configFilePath).configInserts(configInserts));
    }

    public NatsServerRunner(String configFilePath, int port, boolean debug) throws IOException {
        this(NatsServerRunner.builder().port(port).debug(debug).configFilePath(configFilePath));
    }

    public NatsServerRunner(String[] customArgs) throws IOException {
        this(NatsServerRunner.builder().customArgs(customArgs));
    }

    public NatsServerRunner(String[] customArgs, boolean debug) throws IOException {
        this(NatsServerRunner.builder().debug(debug).customArgs(customArgs));
    }

    public NatsServerRunner(String[] customArgs, boolean debug, boolean jetstream) throws IOException {
        this(NatsServerRunner.builder().debug(debug).jetstream(jetstream).customArgs(customArgs));
    }

    public NatsServerRunner(String[] customArgs, int port, boolean debug) throws IOException {
        this(NatsServerRunner.builder().port(port).debug(debug).customArgs(customArgs));
    }

    public NatsServerRunner(int port, boolean debug, boolean jetstream, String configFilePath, String[] configInserts, String[] customArgs) throws IOException {
        this(NatsServerRunner.builder().port(port).debug(debug).jetstream(jetstream).configFilePath(configFilePath).configInserts(configInserts).customArgs(customArgs));
    }

    public NatsServerRunner(NatsServerRunnerOptions natsServerRunnerOptions) throws Exception {
        this(NatsServerRunner.builder().runnerOptions(natsServerRunnerOptions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NatsServerRunner(Builder b) throws IOException {
        this._executablePath = b.executablePath == null ? NatsRunnerUtils.getResolvedServerPath() : b.executablePath.toString();
        this._ports = b.ports;
        Integer tempPort = this._ports.get("config_port");
        if (tempPort == null) {
            this._ports.put("config_port", -1);
            tempPort = -1;
        }
        if (tempPort == -1) {
            tempPort = NatsRunnerUtils.nextPort();
        }
        this._ports.put("user_port", tempPort);
        int userPort = tempPort;
        this._ports.put("nats_port", -1);
        this._ports.put("non_nats_port", -1);
        if (b.output == null) {
            this._displayOut = DefaultOutputSupplier.get();
            this._displayOut.setLevel(DefaultOutputLevel);
        } else {
            this._displayOut = b.output;
            if (b.outputLevel != null) {
                this._displayOut.setLevel(b.outputLevel);
            }
        }
        long procCheckWait = b.processCheckWait == null ? DEFAULT_PROCESS_CHECK_WAIT : b.processCheckWait;
        int procCheckTries = b.processCheckTries == null ? DEFAULT_PROCESS_CHECK_TRIES : b.processCheckTries;
        long connCheckWait = b.connectCheckWait == null ? DEFAULT_RUN_CHECK_WAIT : b.connectCheckWait;
        int connCheckTries = b.connectCheckTries == null ? DEFAULT_RUN_CHECK_TRIES : b.connectCheckTries;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this._executablePath);
        try {
            this._configFile = File.createTempFile("nats_java_test", ".conf");
            BufferedWriter writer = new BufferedWriter(new FileWriter(this._configFile));
            if (b.configFilePath == null) {
                this._ports.put("nats_port", userPort);
                this.writePortLine(writer, userPort);
            } else {
                this.processSuppliedConfigFile(writer, b.configFilePath);
            }
            if (b.configInserts != null) {
                for (String s : b.configInserts) {
                    this.writeLine(writer, s);
                }
            }
            writer.flush();
            writer.close();
            cmd.add("--config");
            cmd.add(this._configFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            this._displayOut.error("%%% Error creating config file: " + ioe);
            throw ioe;
        }
        if (b.jetstream) {
            cmd.add("-js");
        }
        if (b.customArgs != null) {
            cmd.addAll(b.customArgs);
        }
        if (b.debugLevel != null) {
            cmd.add(b.debugLevel.getCmdOption());
        }
        this._cmdLine = String.join((CharSequence)" ", cmd);
        NatsOutputLogger nol = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            pb.redirectError(ProcessBuilder.Redirect.PIPE);
            pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
            this._displayOut.info("%%% Starting [" + this._cmdLine + "] with redirected IO");
            this.process = pb.start();
            nol = NatsOutputLogger.logOutput(this._displayOut, this.process, "nats-server");
            int tries = procCheckTries;
            do {
                this.sleep(procCheckWait);
            } while (!this.process.isAlive() && --tries > 0);
            InetSocketAddress addr = new InetSocketAddress("localhost", (int)this._ports.get("nats_port"));
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(true);
            if (connCheckTries > 0) {
                boolean checking = true;
                tries = connCheckTries;
                do {
                    try {
                        socketChannel.connect(addr);
                        checking = false;
                    }
                    catch (ConnectException e) {
                        if (--tries == 0) {
                            throw e;
                        }
                        this.sleep(connCheckWait);
                    }
                    finally {
                        socketChannel.close();
                    }
                } while (checking);
            }
            this._displayOut.info("%%% Started [" + this._cmdLine + "]");
            nol.endStartupPhase();
        }
        catch (IOException ex) {
            this._displayOut.error("%%% Failed to run [" + this._cmdLine + "]");
            String exMsg = ex.getMessage();
            if (exMsg != null) {
                this._displayOut.error("    " + ex.getMessage());
            }
            this._displayOut.error("%%% Make sure that the nats-server is installed and in your PATH.");
            this._displayOut.error("%%% See https://github.com/nats-io/nats-server for information on installation");
            StringBuilder exMessage = new StringBuilder("Failed to run [").append(this._cmdLine).append("]");
            if (b.fullErrorReportOnStartup) {
                if (nol != null) {
                    for (String line : nol.getStartupLines()) {
                        exMessage.append(System.lineSeparator()).append(line);
                    }
                }
                if (this._cmdLine.contains("--config")) {
                    String configPath = this._configFile.getAbsolutePath();
                    String configSep = this.getConfigSep(configPath);
                    exMessage.append(System.lineSeparator()).append(configSep);
                    exMessage.append(System.lineSeparator()).append(configPath);
                    exMessage.append(System.lineSeparator()).append(configSep);
                    try {
                        List<String> lines = Files.readAllLines(this._configFile.toPath());
                        for (String line : lines) {
                            exMessage.append(System.lineSeparator()).append(line);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    exMessage.append(System.lineSeparator()).append(configSep);
                }
            }
            throw new IllegalStateException(exMessage.toString());
        }
    }

    private String getConfigSep(String configPath) {
        StringBuilder sep = new StringBuilder("------------------------------");
        int len = configPath.length();
        while (sep.length() < len) {
            sep.append((CharSequence)sep);
        }
        return sep.substring(0, len);
    }

    private void processSuppliedConfigFile(BufferedWriter writer, Path configFilePath) throws IOException {
        Matcher constructionPortMatcher = Pattern.compile("port: (\\d+)").matcher("");
        Matcher mappedPortMatcher = Pattern.compile("port: <(\\w+)>").matcher("");
        BufferedReader reader = new BufferedReader(new FileReader(configFilePath.toFile()));
        boolean userTaken = false;
        int userPort = this._ports.get("user_port");
        int natsPort = -1;
        String line = reader.readLine();
        int level = 0;
        while (line != null) {
            String trim = line.trim();
            if (trim.endsWith("{")) {
                ++level;
            } else if (trim.startsWith("}")) {
                --level;
            }
            constructionPortMatcher.reset(line);
            if (constructionPortMatcher.find()) {
                if (userTaken) {
                    throw new IOException("Improper configuration, cannot assign port multiple times.");
                }
                userTaken = true;
                if (level == 0) {
                    natsPort = userPort;
                } else {
                    this._ports.put("non_nats_port", userPort);
                }
                this.writeLine(writer, line.replace(constructionPortMatcher.group(1), Integer.toString(userPort)));
            } else {
                mappedPortMatcher.reset(line);
                if (mappedPortMatcher.find()) {
                    int end;
                    int start = line.indexOf("<");
                    String key = line.substring(start + 1, end = line.indexOf(">"));
                    Integer mapped = this._ports.get(key);
                    if (mapped == null) {
                        mapped = NatsRunnerUtils.nextPort();
                        this._ports.put(key, mapped);
                    }
                    this.writeLine(writer, line.replace("<" + key + ">", mapped.toString()));
                    if (level == 0) {
                        natsPort = mapped;
                    } else {
                        this._ports.put("non_nats_port", mapped);
                    }
                } else {
                    this.writeLine(writer, line);
                }
            }
            line = reader.readLine();
        }
        reader.close();
        if (natsPort == -1) {
            if (userTaken) {
                this._ports.put("nats_port", 4222);
            } else {
                this._ports.put("nats_port", userPort);
                this.writePortLine(writer, userPort);
            }
        } else {
            this._ports.put("nats_port", natsPort);
        }
    }

    private void writePortLine(BufferedWriter writer, int port) throws IOException {
        this.writeLine(writer, "port: " + port);
    }

    private void writeLine(BufferedWriter writer, String line) throws IOException {
        writer.write(line);
        writer.write("\n");
    }

    private void sleep(long sleep) {
        try {
            Thread.sleep(sleep);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getExecutablePath() {
        return this._executablePath;
    }

    public int getPort() {
        return this.getUserPort();
    }

    public int getUserPort() {
        return this._ports.get("user_port");
    }

    public int getNatsPort() {
        return this._ports.get("nats_port");
    }

    public int getConfigPort() {
        return this._ports.get("config_port");
    }

    public int getNonNatsPort() {
        return this._ports.get("non_nats_port");
    }

    public Integer getPort(String key) {
        return this._ports.get(key);
    }

    public String getConfigFile() {
        return this._configFile.getAbsolutePath();
    }

    public String getURI() {
        return NatsRunnerUtils.getNatsLocalhostUri(this.getNatsPort());
    }

    public String getCmdLine() {
        return this._cmdLine;
    }

    public void shutdown(boolean wait) throws InterruptedException {
        if (this.process != null) {
            this.process.destroy();
            this._displayOut.info("%%% Shut down [" + this._cmdLine + "]");
            if (wait) {
                this.process.waitFor();
            }
            this.process = null;
        }
    }

    public void shutdown() throws InterruptedException {
        this.shutdown(true);
    }

    @Override
    public void close() throws Exception {
        this.shutdown(true);
    }

    public static Supplier<Output> getDefaultOutputSupplier() {
        return DefaultOutputSupplier;
    }

    public static void setDefaultOutputSupplier(Supplier<Output> outputSupplier) {
        DefaultOutputSupplier = outputSupplier == null ? DefaultLoggingSupplier : outputSupplier;
    }

    public static Level getDefaultOutputLevel() {
        return DefaultOutputLevel;
    }

    public static void setDefaultOutputLevel(Level defaultOutputLevel) {
        DefaultOutputLevel = defaultOutputLevel;
    }

    public static String getPreferredServerPath() {
        return PreferredServerPath;
    }

    public static void setPreferredServerPath(String preferredServerPath) {
        PreferredServerPath = preferredServerPath == null || preferredServerPath.length() == 0 ? null : preferredServerPath;
    }

    public static void clearPreferredServerPath() {
        PreferredServerPath = null;
    }

    public static class Builder {
        Map<String, Integer> ports = new HashMap<String, Integer>();
        DebugLevel debugLevel;
        boolean jetstream;
        Path configFilePath;
        List<String> configInserts;
        List<String> customArgs;
        Path executablePath;
        Output output;
        Level outputLevel;
        Long processCheckWait;
        Integer processCheckTries;
        Long connectCheckWait;
        Integer connectCheckTries;
        boolean fullErrorReportOnStartup = true;

        public Builder port(Integer port) {
            return this.port("config_port", port);
        }

        public Builder port(String key, Integer port) {
            if (port == null) {
                this.ports.remove(key);
            } else {
                this.ports.put(key, port);
            }
            return this;
        }

        public Builder ports(Map<String, Integer> ports) {
            this.ports.clear();
            if (ports != null) {
                this.ports.putAll(ports);
            }
            return this;
        }

        public Builder debugLevel(DebugLevel debugLevel) {
            this.debugLevel = debugLevel;
            return this;
        }

        public Builder debug(boolean trueForDebugTraceFalseForNoDebug) {
            this.debugLevel = trueForDebugTraceFalseForNoDebug ? DebugLevel.DEBUG_TRACE : null;
            return this;
        }

        public Builder jetstream() {
            this.jetstream = true;
            return this;
        }

        public Builder jetstream(boolean jetStream) {
            this.jetstream = jetStream;
            return this;
        }

        public Builder configFilePath(String configFilePath) {
            this.configFilePath = configFilePath == null ? null : Paths.get(configFilePath, new String[0]);
            return this;
        }

        public Builder configFilePath(Path configFilePath) {
            this.configFilePath = configFilePath;
            return this;
        }

        public Builder configInserts(List<String> configInserts) {
            this.configInserts = configInserts == null || configInserts.isEmpty() ? null : configInserts;
            return this;
        }

        public Builder configInserts(String[] configInserts) {
            this.configInserts = configInserts == null || configInserts.length == 0 ? null : Arrays.asList(configInserts);
            return this;
        }

        public Builder customArgs(List<String> customArgs) {
            this.customArgs = customArgs == null || customArgs.isEmpty() ? null : customArgs;
            return this;
        }

        public Builder customArgs(String[] customArgs) {
            this.customArgs = customArgs == null || customArgs.length == 0 ? null : Arrays.asList(customArgs);
            return this;
        }

        public Builder executablePath(String executablePath) {
            this.executablePath = executablePath == null ? null : Paths.get(executablePath, new String[0]);
            return this;
        }

        public Builder executablePath(Path executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        public Builder output(Output output) {
            this.output = output;
            return this;
        }

        public Builder outputLogger(Logger logger) {
            this.output = logger == null ? null : new LoggingOutput(logger);
            return this;
        }

        public Builder outputLevel(Level level) {
            this.outputLevel = level;
            return this;
        }

        public Builder processCheckWait(Long processWait) {
            this.processCheckWait = processWait;
            return this;
        }

        public Builder processCheckTries(Integer processCheckTries) {
            this.processCheckTries = processCheckTries;
            return this;
        }

        public Builder connectCheckWait(Long connectCheckWait) {
            this.connectCheckWait = connectCheckWait;
            return this;
        }

        public Builder connectCheckTries(Integer connectCheckTries) {
            this.connectCheckTries = connectCheckTries;
            return this;
        }

        public Builder fullErrorReportOnStartup(boolean fullErrorReportOnStartup) {
            this.fullErrorReportOnStartup = fullErrorReportOnStartup;
            return this;
        }

        public Builder runnerOptions(NatsServerRunnerOptions nsro) {
            this.port(nsro.port()).debugLevel(nsro.debugLevel()).jetstream(nsro.jetStream()).configFilePath(nsro.configFilePath()).configInserts(nsro.configInserts()).customArgs(nsro.customArgs()).executablePath(nsro.executablePath()).outputLogger(nsro.logger()).outputLevel(nsro.logLevel());
            return this;
        }

        public NatsServerRunner build() throws IOException {
            return new NatsServerRunner(this);
        }

        public NatsServerRunnerOptions buildOptions() {
            return new NatsServerRunnerOptionsImpl(this);
        }
    }
}

