/*
 * Decompiled with CFR 0.152.
 */
package nats.io;

import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nats.io.DebugLevel;
import nats.io.NatsServerRunner;
import nats.io.NatsServerRunnerOptions;

public class NatsServerRunnerOptionsImpl
implements NatsServerRunnerOptions {
    private final Integer port;
    private final DebugLevel debugLevel;
    private final boolean jetstream;
    private final Path configFilePath;
    private final List<String> configInserts;
    private final List<String> customArgs;
    private final Path executablePath;
    private final Logger logger;
    private final Level logLevel;

    public NatsServerRunnerOptionsImpl(NatsServerRunner.Builder builder) {
        this.port = builder.ports.get("config_port");
        this.debugLevel = builder.debugLevel;
        this.jetstream = builder.jetstream;
        this.configFilePath = builder.configFilePath;
        this.configInserts = builder.configInserts;
        this.customArgs = builder.customArgs;
        this.executablePath = builder.executablePath;
        this.logLevel = builder.outputLevel;
        this.logger = builder.output == null ? null : builder.output.getLogger();
    }

    @Override
    public Integer port() {
        return this.port;
    }

    @Override
    public DebugLevel debugLevel() {
        return this.debugLevel;
    }

    @Override
    public boolean jetStream() {
        return this.jetstream;
    }

    @Override
    public Path configFilePath() {
        return this.configFilePath;
    }

    @Override
    public List<String> configInserts() {
        return this.configInserts;
    }

    @Override
    public List<String> customArgs() {
        return this.customArgs;
    }

    @Override
    public Path executablePath() {
        return this.executablePath;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public Level logLevel() {
        return this.logLevel;
    }
}

