/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Options;
import io.nats.client.support.JsPrefixManager;
import java.time.Duration;

public class JetStreamOptions {
    public static final Duration DEFAULT_TIMEOUT = Options.DEFAULT_CONNECTION_TIMEOUT;
    public static final JetStreamOptions DEFAULT_JS_OPTIONS = new Builder().build();
    private final String prefix;
    private final Duration requestTimeout;

    private JetStreamOptions(String prefix, Duration requestTimeout) {
        this.prefix = prefix;
        this.requestTimeout = requestTimeout;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static JetStreamOptions defaultOptions() {
        return DEFAULT_JS_OPTIONS;
    }

    public static class Builder {
        private String prefix;
        private Duration requestTimeout;

        public Builder requestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public JetStreamOptions build() {
            this.prefix = JsPrefixManager.addPrefix(this.prefix);
            this.requestTimeout = this.requestTimeout == null ? DEFAULT_TIMEOUT : this.requestTimeout;
            return new JetStreamOptions(this.prefix, this.requestTimeout);
        }
    }
}

