/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.impl.Headers;
import io.nats.client.support.NatsConstants;
import io.nats.client.support.Status;
import io.nats.client.support.Token;
import io.nats.client.support.TokenType;

public class IncomingHeadersProcessor {
    private final int serializedLength;
    private Headers headers;
    private Status inlineStatus;

    public IncomingHeadersProcessor(byte[] serialized) {
        if (serialized == null || serialized.length == 0) {
            throw new IllegalArgumentException("Serialized header cannot be null or empty.");
        }
        for (int x = 0; x < NatsConstants.VERSION_BYTES_LEN; ++x) {
            if (serialized[x] == NatsConstants.VERSION_BYTES[x]) continue;
            throw new IllegalArgumentException("Invalid header version");
        }
        this.serializedLength = serialized.length;
        new Token(serialized, this.serializedLength, this.serializedLength - 2, TokenType.CRLF);
        Token token = new Token(serialized, this.serializedLength, NatsConstants.VERSION_BYTES_LEN, null);
        if (token.isType(TokenType.SPACE)) {
            this.initStatus(serialized, this.serializedLength, token);
        } else if (token.isType(TokenType.CRLF)) {
            this.initHeader(serialized, this.serializedLength, token);
        } else {
            throw new IllegalArgumentException("Invalid header composition");
        }
    }

    public int getSerializedLength() {
        return this.serializedLength;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Status getStatus() {
        return this.inlineStatus;
    }

    private void initHeader(byte[] serialized, int len, Token tCrlf) {
        this.headers = new Headers();
        Token peek = new Token(serialized, len, tCrlf, null);
        while (peek.isType(TokenType.TEXT)) {
            Token tKey = new Token(serialized, len, tCrlf, TokenType.KEY);
            Token tVal = new Token(serialized, len, tKey, null);
            if (tVal.isType(TokenType.SPACE)) {
                tVal = new Token(serialized, len, tVal, null);
            }
            if (tVal.isType(TokenType.TEXT)) {
                tCrlf = new Token(serialized, len, tVal, TokenType.CRLF);
            } else {
                tVal.mustBe(TokenType.CRLF);
                tCrlf = tVal;
            }
            this.headers.add(tKey.getValue(), tVal.getValue());
            peek = new Token(serialized, len, tCrlf, null);
        }
        peek.mustBe(TokenType.CRLF);
        if (this.headers.size() == 0) {
            throw new IllegalArgumentException("Invalid header composition");
        }
    }

    private void initStatus(byte[] serialized, int len, Token tSpace) {
        Token tCode = new Token(serialized, len, tSpace, TokenType.WORD);
        Token tVal = new Token(serialized, len, tCode, null);
        if (tVal.isType(TokenType.SPACE)) {
            tVal = new Token(serialized, len, tVal, TokenType.TEXT);
            new Token(serialized, len, tVal, TokenType.CRLF);
        } else {
            tVal.mustBe(TokenType.CRLF);
        }
        this.inlineStatus = new Status(tCode, tVal);
    }
}

