/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class JsPrefixManager {
    private static final Set<String> JS_PREFIXES = Collections.synchronizedSet(new HashSet());

    private JsPrefixManager() {
    }

    public static String addPrefix(String prefix) {
        if (Validator.nullOrEmpty(prefix)) {
            return "$JS.API.";
        }
        if (!(prefix = Validator.validateJetStreamPrefix(prefix)).endsWith(".")) {
            prefix = prefix + ".";
        }
        JS_PREFIXES.add(prefix);
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasPrefix(String replyTo) {
        if (replyTo != null) {
            if (replyTo.startsWith("$JS.")) {
                return true;
            }
            Set<String> set = JS_PREFIXES;
            synchronized (set) {
                for (String prefix : JS_PREFIXES) {
                    if (!replyTo.startsWith(prefix)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

