/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.Token;
import java.util.HashMap;
import java.util.Map;

public class Status {
    private final int code;
    private final String message;
    private static final Map<Integer, String> MESSAGE_MAP = new HashMap<Integer, String>();

    public Status(int code, String message) {
        this.code = code;
        this.message = message == null ? this.makeMessage(code) : message;
    }

    public Status(Token codeToken, Token messageToken) {
        this(Status.extractCode(codeToken), Status.extractMessage(messageToken));
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    private static String extractMessage(Token messageToken) {
        return messageToken.hasValue() ? messageToken.getValue() : null;
    }

    private static int extractCode(Token codeToken) {
        try {
            return Integer.parseInt(codeToken.getValue());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid header status code");
        }
    }

    private String makeMessage(int code) {
        String message = MESSAGE_MAP.get(code);
        return message == null ? "Server Status Message: " + code : message;
    }

    public String toString() {
        return "Status{code=" + this.code + ", message='" + this.message + '\'' + '}';
    }

    static {
        MESSAGE_MAP.put(503, "No Responders Available For Request");
    }
}

