/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.ClosedCallback;
import io.nats.client.DisconnectedCallback;
import io.nats.client.ExceptionHandler;
import io.nats.client.ReconnectedCallback;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;

class Options {
    private URI url;
    private String host;
    private int port;
    private String username;
    private String password;
    private List<URI> servers;
    private boolean noRandomize;
    private String connectionName;
    private boolean verbose;
    private boolean pedantic;
    private boolean secure;
    private boolean reconnectAllowed;
    private int maxReconnect;
    private long reconnectWait;
    private int connectionTimeout;
    private long pingInterval;
    private int maxPingsOut;
    private ExceptionHandler exceptionHandler;
    private SSLContext sslContext;
    private boolean tlsDebug;
    private int maxPendingMsgs;
    protected DisconnectedCallback disconnectedCB;
    protected ClosedCallback closedCB;
    protected ReconnectedCallback reconnectedCB;
    protected ExceptionHandler asyncErrorCB;

    Options() {
    }

    public int getMaxPendingMsgs() {
        return this.maxPendingMsgs;
    }

    public void setMaxPendingMsgs(int subChanLen) {
        this.maxPendingMsgs = subChanLen;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
        if (url != null) {
            if (url.getHost() != null) {
                this.setHost(url.getHost());
            }
            this.setPort(url.getPort());
            String userInfo = url.getRawUserInfo();
            if (userInfo != null) {
                String[] userPass = userInfo.split(":");
                if (userPass.length > 2) {
                    throw new IllegalArgumentException("Bad user info in NATS URI: " + userInfo);
                }
                this.setUsername(userPass[0]);
                if (userPass.length == 2) {
                    this.setPassword(userPass[1]);
                }
            }
        }
    }

    public void setUrl(String url) {
        if (url == null) {
            return;
        }
        if (url.isEmpty()) {
            return;
        }
        try {
            this.url = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Bad server URL: " + url);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<URI> getServers() {
        return this.servers;
    }

    public void setServers(String[] serverArray) {
        if (serverArray != null && serverArray.length != 0) {
            if (this.servers == null) {
                this.servers = new ArrayList<URI>();
            }
            for (String s : serverArray) {
                if (s == null || s.isEmpty()) continue;
                try {
                    this.servers.add(new URI(s.trim()));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Bad server URL: " + s);
                }
            }
        }
    }

    public void setServers(List<URI> servers) {
        this.servers = servers;
    }

    public boolean isNoRandomize() {
        return this.noRandomize;
    }

    public void setNoRandomize(boolean randomizeDisabled) {
        this.noRandomize = randomizeDisabled;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isTlsDebug() {
        return this.tlsDebug;
    }

    public void setTlsDebug(boolean debug) {
        this.tlsDebug = debug;
    }

    public boolean isReconnectAllowed() {
        return this.reconnectAllowed;
    }

    public void setReconnectAllowed(boolean reconnectAllowed) {
        this.reconnectAllowed = reconnectAllowed;
    }

    public int getMaxReconnect() {
        return this.maxReconnect;
    }

    public void setMaxReconnect(int maxReconnect) {
        this.maxReconnect = maxReconnect;
    }

    public long getReconnectWait() {
        return this.reconnectWait;
    }

    public void setReconnectWait(long reconnectWait) {
        this.reconnectWait = reconnectWait;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public long getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public int getMaxPingsOut() {
        return this.maxPingsOut;
    }

    public void setMaxPingsOut(int maxPingsOut) {
        this.maxPingsOut = maxPingsOut;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ClosedCallback getClosedCallback() {
        return this.closedCB;
    }

    public void setClosedCallback(ClosedCallback cb) {
        this.closedCB = cb;
    }

    public ReconnectedCallback getReconnectedCallback() {
        return this.reconnectedCB;
    }

    public void setReconnectedCallback(ReconnectedCallback cb) {
        this.reconnectedCB = cb;
    }

    public DisconnectedCallback getDisconnectedCallback() {
        return this.disconnectedCB;
    }

    public void setDisconnectedCallback(DisconnectedCallback cb) {
        this.disconnectedCB = cb;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }
}

