/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Channel;
import io.nats.client.Connection;
import io.nats.client.ConnectionImpl;
import io.nats.client.Message;
import io.nats.client.Subscription;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SubscriptionImpl
implements Subscription {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    final Lock mu = new ReentrantLock();
    long sid;
    String subject = null;
    String queue;
    long msgs;
    AtomicLong delivered = new AtomicLong();
    long bytes;
    int pendingMax;
    int max;
    protected boolean closed;
    protected boolean connClosed;
    boolean sc;
    ConnectionImpl conn = null;
    Channel<Message> mch;

    SubscriptionImpl(ConnectionImpl conn, String subject, String queue, int maxPending) {
        this.conn = conn;
        this.subject = subject;
        this.queue = queue;
        this.setMaxPending(maxPending);
        this.mch = new Channel(maxPending);
    }

    void closeChannel() {
        this.mu.lock();
        try {
            if (this.mch != null) {
                this.mch.close();
                this.mch = null;
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    public Channel<Message> getChannel() {
        return this.mch;
    }

    public void setChannel(Channel<Message> ch) {
        this.mch = ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tallyMessage(long length) {
        this.mu.lock();
        try {
            if (this.max > 0 && this.msgs > (long)this.max) {
                boolean bl = true;
                return bl;
            }
            ++this.msgs;
            this.bytes += this.bytes;
        }
        finally {
            this.mu.unlock();
        }
        return false;
    }

    boolean addMessage(Message m) {
        if (this.mch != null) {
            if (this.mch.getCount() >= this.getMaxPending()) {
                return false;
            }
            this.sc = false;
            this.mch.add(m);
        }
        return true;
    }

    @Override
    public boolean isValid() {
        this.mu.lock();
        try {
            boolean bl = this.conn != null;
            return bl;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public void unsubscribe() throws IOException {
        ConnectionImpl c;
        this.mu.lock();
        try {
            c = this.conn;
        }
        finally {
            this.mu.unlock();
        }
        if (c == null) {
            throw new IllegalStateException("nats: Invalid Subscription");
        }
        c.unsubscribe(this, 0);
    }

    @Override
    public void autoUnsubscribe(int max) throws IOException {
        ConnectionImpl c = null;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: Invalid Subscription");
            }
            c = this.conn;
        }
        finally {
            this.mu.unlock();
        }
        c.unsubscribe(this, max);
    }

    @Override
    public void close() {
        try {
            this.logger.trace("Calling unsubscribe from AutoCloseable.close()");
            this.unsubscribe();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected long getSid() {
        return this.sid;
    }

    protected void setSid(long id) {
        this.sid = id;
    }

    protected int getMaxPending() {
        return this.pendingMax;
    }

    protected void setMaxPending(int pending) {
        this.pendingMax = pending;
        if (pending <= 0) {
            this.pendingMax = 65536;
        }
    }

    protected Connection getConnection() {
        return this.conn;
    }

    protected void setConnection(ConnectionImpl conn) {
        this.conn = conn;
    }

    @Override
    public int getQueuedMessageCount() {
        if (this.mch != null) {
            return this.mch.getCount();
        }
        return 0;
    }

    public String toString() {
        String s = String.format("{subject=%s, queue=%s, sid=%d, queued=%d, max=%d, valid=%b}", this.getSubject(), this.getQueue() == null ? "null" : this.getQueue(), this.getSid(), this.getQueuedMessageCount(), this.getMaxPending(), this.isValid());
        return s;
    }

    protected void setSlowConsumer(boolean sc) {
        this.sc = sc;
    }

    protected boolean isSlowConsumer() {
        return this.sc;
    }

    protected boolean processMsg(Message msg) {
        return true;
    }

    protected void setMax(int max) {
        this.max = max;
    }

    Lock getLock() {
        return this.mu;
    }
}

