/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Channel<T> {
    static final Logger logger = LoggerFactory.getLogger(Channel.class);
    LinkedBlockingQueue<T> q;
    T defaultVal = null;

    Channel() {
        this.q = new LinkedBlockingQueue();
    }

    Channel(LinkedBlockingQueue<T> queue) {
        this.q = queue;
    }

    Channel(int capacity) {
        this.q = capacity <= 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(capacity);
    }

    public Channel(Collection<T> c) {
        this.q = new LinkedBlockingQueue<T>(c);
    }

    T get() {
        T result = this.defaultVal;
        try {
            result = this.get(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new Error("Unexpected error: " + e.getMessage());
        }
        return result;
    }

    synchronized T get(long timeout) throws TimeoutException {
        return this.get(timeout, TimeUnit.MILLISECONDS);
    }

    T get(long timeout, TimeUnit unit) throws TimeoutException {
        T item = this.defaultVal;
        try {
            if (timeout < 0L) {
                item = this.q.take();
            } else {
                item = this.q.poll(timeout, unit);
                if (item == null) {
                    throw new TimeoutException("Channel timed out waiting for items");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return item;
    }

    T poll() {
        return this.q.poll();
    }

    boolean add(T item) {
        return this.q.offer(item);
    }

    public void close() {
        this.q.clear();
    }

    int getCount() {
        return this.q.size();
    }
}

