/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.ConnectionImpl;
import java.nio.ByteBuffer;
import java.text.ParseException;

final class Parser {
    private ConnectionImpl conn;
    NatsOp state = NatsOp.OP_START;
    byte[] argBufBase = new byte[65536];
    ByteBuffer argBufStream = null;
    byte[] msgBufBase = new byte[65536];
    ByteBuffer msgBufStream = null;

    public Parser(ConnectionImpl connectionImpl) {
        this.argBufStream = ByteBuffer.wrap(this.argBufBase);
        this.msgBufStream = ByteBuffer.wrap(this.msgBufBase);
        this.conn = connectionImpl;
        this.conn.ps = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parse(byte[] buffer, int len) throws ParseException {
        boolean error = false;
        int i = 0;
        while (true) {
            block111: {
                if (i >= len) {
                    return;
                }
                char b = (char)buffer[i];
                block1 : switch (this.state) {
                    case OP_START: {
                        switch (b) {
                            case 'M': 
                            case 'm': {
                                this.state = NatsOp.OP_M;
                                break block1;
                            }
                            case 'P': 
                            case 'p': {
                                this.state = NatsOp.OP_P;
                                break block1;
                            }
                            case '+': {
                                this.state = NatsOp.OP_PLUS;
                                break block1;
                            }
                            case '-': {
                                this.state = NatsOp.OP_MINUS;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_M: {
                        switch (b) {
                            case 'S': 
                            case 's': {
                                this.state = NatsOp.OP_MS;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_MS: {
                        switch (b) {
                            case 'G': 
                            case 'g': {
                                this.state = NatsOp.OP_MSG;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_MSG: {
                        switch (b) {
                            case '\t': 
                            case ' ': {
                                this.state = NatsOp.OP_MSG_SPC;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_MSG_SPC: {
                        switch (b) {
                            case ' ': {
                                break block1;
                            }
                            case '\t': {
                                break block1;
                            }
                        }
                        this.state = NatsOp.MSG_ARG;
                        --i;
                        break;
                    }
                    case MSG_ARG: {
                        switch (b) {
                            case '\r': {
                                break block1;
                            }
                            case '\n': {
                                try {
                                    this.conn.processMsgArgs(this.argBufBase, this.argBufStream.position());
                                    this.argBufStream.position(0);
                                    if (this.conn.msgArgs.size > this.msgBufBase.length) {
                                        this.msgBufBase = new byte[this.conn.msgArgs.size + 1];
                                        this.msgBufStream = ByteBuffer.wrap(this.msgBufBase);
                                    }
                                    this.state = NatsOp.MSG_PAYLOAD;
                                }
                                catch (ParseException ex) {
                                    error = true;
                                }
                                break block1;
                            }
                        }
                        this.argBufStream.put((byte)b);
                        break;
                    }
                    case MSG_PAYLOAD: {
                        long position = this.msgBufStream.position();
                        if (position >= (long)this.conn.msgArgs.size) {
                            this.conn.processMsg(this.msgBufBase, position);
                            this.msgBufStream.position(0);
                            this.state = NatsOp.MSG_END;
                            break;
                        }
                        this.msgBufStream.put((byte)b);
                        break;
                    }
                    case MSG_END: {
                        switch (b) {
                            case '\n': {
                                this.state = NatsOp.OP_START;
                                break block1;
                            }
                        }
                        break block111;
                    }
                    case OP_PLUS: {
                        switch (b) {
                            case 'O': 
                            case 'o': {
                                this.state = NatsOp.OP_PLUS_O;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_PLUS_O: {
                        switch (b) {
                            case 'K': 
                            case 'k': {
                                this.state = NatsOp.OP_PLUS_OK;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_PLUS_OK: {
                        switch (b) {
                            case '\n': {
                                this.conn.processOK();
                                this.state = NatsOp.OP_START;
                                break block1;
                            }
                        }
                        break;
                    }
                    case OP_MINUS: {
                        switch (b) {
                            case 'E': 
                            case 'e': {
                                this.state = NatsOp.OP_MINUS_E;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_MINUS_E: {
                        switch (b) {
                            case 'R': 
                            case 'r': {
                                this.state = NatsOp.OP_MINUS_ER;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_MINUS_ER: {
                        switch (b) {
                            case 'R': 
                            case 'r': {
                                this.state = NatsOp.OP_MINUS_ERR;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_MINUS_ERR: {
                        switch (b) {
                            case '\t': 
                            case ' ': {
                                this.state = NatsOp.OP_MINUS_ERR_SPC;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_MINUS_ERR_SPC: {
                        switch (b) {
                            case '\t': 
                            case ' ': {
                                this.state = NatsOp.OP_MINUS_ERR_SPC;
                                break block1;
                            }
                        }
                        this.state = NatsOp.MINUS_ERR_ARG;
                        --i;
                        break;
                    }
                    case MINUS_ERR_ARG: {
                        switch (b) {
                            case '\r': {
                                break block1;
                            }
                            case '\n': {
                                this.conn.processErr(this.argBufStream);
                                this.argBufStream.position(0);
                                this.state = NatsOp.OP_START;
                                break block1;
                            }
                        }
                        this.argBufStream.put((byte)b);
                        break;
                    }
                    case OP_P: {
                        switch (b) {
                            case 'I': 
                            case 'i': {
                                this.state = NatsOp.OP_PI;
                                break block1;
                            }
                            case 'O': 
                            case 'o': {
                                this.state = NatsOp.OP_PO;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_PO: {
                        switch (b) {
                            case 'N': 
                            case 'n': {
                                this.state = NatsOp.OP_PON;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_PON: {
                        switch (b) {
                            case 'G': 
                            case 'g': {
                                this.state = NatsOp.OP_PONG;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_PONG: {
                        switch (b) {
                            case '\r': {
                                break block1;
                            }
                            case '\n': {
                                this.conn.processPong();
                                this.state = NatsOp.OP_START;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_PI: {
                        switch (b) {
                            case 'N': 
                            case 'n': {
                                this.state = NatsOp.OP_PIN;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_PIN: {
                        switch (b) {
                            case 'G': 
                            case 'g': {
                                this.state = NatsOp.OP_PING;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                    case OP_PING: {
                        switch (b) {
                            case '\r': {
                                break block1;
                            }
                            case '\n': {
                                this.conn.processPing();
                                this.state = NatsOp.OP_START;
                                break block1;
                            }
                        }
                        error = true;
                        break;
                    }
                }
                if (error) {
                    error = false;
                    throw new ParseException(String.format("Parse Error [%s], [%s] [%d]", new Object[]{this.state, new String(buffer), this.argBufStream.position()}), this.argBufStream.position());
                }
            }
            ++i;
        }
    }

    static enum NatsOp {
        OP_START,
        OP_PLUS,
        OP_PLUS_O,
        OP_PLUS_OK,
        OP_MINUS,
        OP_MINUS_E,
        OP_MINUS_ER,
        OP_MINUS_ERR,
        OP_MINUS_ERR_SPC,
        MINUS_ERR_ARG,
        OP_M,
        OP_MS,
        OP_MSG,
        OP_MSG_SPC,
        MSG_ARG,
        MSG_PAYLOAD,
        MSG_END,
        OP_P,
        OP_PI,
        OP_PIN,
        OP_PING,
        OP_PO,
        OP_PON,
        OP_PONG;

    }
}

