/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import java.util.HashMap;
import java.util.Map;

class ServerInfo {
    private String id;
    private String host;
    private int port;
    private String version;
    private String goVersion;
    private boolean authRequired;
    private boolean sslRequired;
    private boolean tlsRequired;
    private boolean tlsVerify;
    private long maxPayload;
    private Map<String, String> parameters = new HashMap<String, String>();

    public ServerInfo(String jsonString) {
        String[] kvPairs;
        try {
            jsonString = jsonString.substring(jsonString.indexOf(123) + 1);
            jsonString = jsonString.substring(0, jsonString.lastIndexOf(125));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        for (String s : kvPairs = jsonString.split(",")) {
            this.addKVPair(s);
        }
        this.id = this.parameters.get("server_id");
        this.host = this.parameters.get("host");
        this.port = Integer.parseInt(this.parameters.get("port"));
        this.version = this.parameters.get("version");
        this.goVersion = this.parameters.get("go");
        this.authRequired = Boolean.parseBoolean(this.parameters.get("auth_required"));
        this.sslRequired = Boolean.parseBoolean(this.parameters.get("ssl_required"));
        this.tlsRequired = Boolean.parseBoolean(this.parameters.get("tls_required"));
        this.tlsVerify = Boolean.parseBoolean(this.parameters.get("tls_verify"));
        this.maxPayload = Long.parseLong(this.parameters.get("max_payload"));
    }

    private void addKVPair(String kvPair) {
        kvPair = kvPair.trim();
        String[] parts = kvPair.split(":");
        String key = parts[0].trim();
        String val = parts[1].trim();
        int lastQuotePos = key.lastIndexOf("\"");
        key = key.substring(1, lastQuotePos);
        if (val.startsWith("\"")) {
            lastQuotePos = val.lastIndexOf("\"");
            val = val.substring(1, lastQuotePos);
        }
        this.parameters.put(key, val);
    }

    String getId() {
        return this.id;
    }

    String getHost() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    String getVersion() {
        return this.version;
    }

    boolean isAuthRequired() {
        return this.authRequired;
    }

    boolean isTlsRequired() {
        return this.tlsRequired;
    }

    long getMaxPayload() {
        return this.maxPayload;
    }

    Map<String, String> getParameters() {
        return this.parameters;
    }

    public String toString() {
        String rv = String.format("INFO {\"server_id\":\"%s\",\"version\":\"%s\",\"go\":\"%s\",\"host\":\"%s\",\"port\":%d,\"auth_required\":%b,\"ssl_required\":%b,\"tls_required\":%b,\"tls_verify\":%b,\"max_payload\":%d}\r\n", this.id, this.version, this.goVersion, this.host, this.port, this.authRequired, this.tlsRequired, this.tlsRequired, this.tlsVerify, this.maxPayload);
        return rv;
    }
}

