/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.AsyncSubscription;
import io.nats.client.Connection;
import io.nats.client.ConnectionImpl;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.NATSThreadFactory;
import io.nats.client.SubscriptionImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class AsyncSubscriptionImpl
extends SubscriptionImpl
implements AsyncSubscription {
    private ExecutorService executor = null;
    private MessageHandler msgHandler;

    protected AsyncSubscriptionImpl(ConnectionImpl nc, String subj, String queue, MessageHandler cb, int maxMsgs, long maxBytes) {
        super(nc, subj, queue, maxMsgs, maxBytes);
        this.msgHandler = cb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processMsg(Message msg) {
        long localMax;
        MessageHandler localHandler;
        Connection localConn;
        this.mu.lock();
        try {
            localConn = this.getConnection();
            localHandler = this.msgHandler;
            localMax = this.max;
        }
        finally {
            this.mu.unlock();
        }
        if (localHandler == null) {
            return true;
        }
        if (localConn == null) {
            return false;
        }
        long delivered = this.tallyDeliveredMessage(msg);
        if (localMax <= 0L || delivered <= localMax) {
            try {
                localHandler.onMessage(msg);
            }
            catch (Exception e) {
                this.logger.error("Error in callback", (Throwable)e);
            }
            if (delivered == localMax) {
                try {
                    this.unsubscribe();
                }
                catch (Exception e) {
                    this.logger.error("Error in unsubscribe", (Throwable)e);
                }
                this.conn = null;
            }
        }
        return true;
    }

    boolean isStarted() {
        return this.executor != null;
    }

    void enable() {
        Runnable msgFeeder = new Runnable(){

            @Override
            public void run() {
                try {
                    AsyncSubscriptionImpl.this.logger.trace("msgFeeder starting for subj: {} sid: {}", (Object)AsyncSubscriptionImpl.this.subject, (Object)AsyncSubscriptionImpl.this.sid);
                    if (AsyncSubscriptionImpl.this.conn == null || AsyncSubscriptionImpl.this.mch == null) {
                        AsyncSubscriptionImpl.this.logger.error("Exiting due to NULL connection or NULL message channel");
                        return;
                    }
                    AsyncSubscriptionImpl.this.logger.trace("msgFeeder entering delivery loop for subj: {} sid: {}", (Object)AsyncSubscriptionImpl.this.subject, (Object)AsyncSubscriptionImpl.this.sid);
                    AsyncSubscriptionImpl.this.conn.deliverMsgs(AsyncSubscriptionImpl.this.mch);
                }
                catch (Exception e) {
                    AsyncSubscriptionImpl.this.logger.error("Error on async subscription for subject {}", (Object)AsyncSubscriptionImpl.this.getSubject());
                    e.printStackTrace();
                }
            }
        };
        if (!this.isStarted()) {
            this.executor = Executors.newSingleThreadExecutor(new NATSThreadFactory("msgfeeder"));
            this.executor.execute(msgFeeder);
            this.logger.trace("Started msgFeeder for subject: " + this.getSubject() + " sid: " + this.getSid());
        }
    }

    void disable() {
        if (this.isStarted()) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    @Override
    public void setMessageHandler(MessageHandler cb) {
        this.msgHandler = cb;
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        if (!this.isValid()) {
            throw new IllegalStateException("nats: invalid subscription");
        }
        this.enable();
        this.conn.sendSubscriptionMessage(this);
    }

    @Override
    public void close() {
        super.close();
        this.disable();
    }
}

