/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.ClosedCallback;
import io.nats.client.Connection;
import io.nats.client.ConnectionImpl;
import io.nats.client.DisconnectedCallback;
import io.nats.client.ExceptionHandler;
import io.nats.client.Options;
import io.nats.client.ReconnectedCallback;
import io.nats.client.TCPConnection;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;

public class ConnectionFactory
implements Cloneable {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 4222;
    public static final String DEFAULT_URL = "nats://localhost:4222";
    static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    public static final int DEFAULT_MAX_RECONNECT = 60;
    public static final int DEFAULT_RECONNECT_WAIT = 2000;
    public static final int DEFAULT_RECONNECT_BUF_SIZE = 0x800000;
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final int DEFAULT_PING_INTERVAL = 120000;
    public static final int DEFAULT_MAX_PINGS_OUT = 2;
    public static final int DEFAULT_MAX_PENDING_MSGS = 65536;
    public static final int DEFAULT_MAX_PENDING_BYTES = 0x4000000;
    private URI url = null;
    private String host = null;
    private int port = -1;
    private String username = null;
    private String password = null;
    private List<URI> servers = null;
    private boolean noRandomize = false;
    private String connectionName = null;
    private boolean verbose = false;
    private boolean pedantic = false;
    private boolean secure = false;
    private boolean reconnectAllowed = true;
    private int maxReconnect = 60;
    private long reconnectWait = 2000L;
    private int reconnectBufSize = 0x800000;
    private int connectionTimeout = 2000;
    private long pingInterval = 120000L;
    private int maxPingsOut = 2;
    private SSLContext sslContext;
    private ExceptionHandler exceptionHandler = null;
    private ClosedCallback closedCallback;
    private DisconnectedCallback disconnectedCallback;
    private ReconnectedCallback reconnectedCallback;
    private String urlString = null;
    private int maxPendingMsgs = 65536;
    private long maxPendingBytes = 0x4000000L;
    private boolean tlsDebug;

    public ConnectionFactory(Properties props) {
        Constructor<?> constructor;
        Class<?> clazz;
        String str;
        Object instance;
        if (props == null) {
            throw new IllegalArgumentException("Properties cannot be null");
        }
        if (props.containsKey("io.nats.client.url")) {
            this.setUrl(props.getProperty("io.nats.client.url", DEFAULT_URL));
        }
        if (props.containsKey("io.nats.client.host")) {
            this.setHost(props.getProperty("io.nats.client.host", DEFAULT_HOST));
        }
        if (props.containsKey("io.nats.client.port")) {
            this.setPort(Integer.parseInt(props.getProperty("io.nats.client.port", Integer.toString(4222))));
        }
        if (props.containsKey("io.nats.client.username")) {
            this.setUsername(props.getProperty("io.nats.client.username", null));
        }
        if (props.containsKey("io.nats.client.password")) {
            this.setPassword(props.getProperty("io.nats.client.password", null));
        }
        if (props.containsKey("io.nats.client.servers")) {
            String str2 = props.getProperty("io.nats.client.servers");
            if (str2.isEmpty()) {
                throw new IllegalArgumentException("io.nats.client.servers cannot be empty");
            }
            String[] servers = str2.trim().split(",\\s*");
            this.setServers(servers);
        }
        if (props.containsKey("io.nats.client.norandomize")) {
            this.setNoRandomize(Boolean.parseBoolean(props.getProperty("io.nats.client.norandomize")));
        }
        if (props.containsKey("io.nats.client.name")) {
            this.setConnectionName(props.getProperty("io.nats.client.name", null));
        }
        if (props.containsKey("io.nats.client.verbose")) {
            this.setVerbose(Boolean.parseBoolean(props.getProperty("io.nats.client.verbose")));
        }
        if (props.containsKey("io.nats.client.pedantic")) {
            this.setPedantic(Boolean.parseBoolean(props.getProperty("io.nats.client.pedantic")));
        }
        if (props.containsKey("io.nats.client.secure")) {
            this.setSecure(Boolean.parseBoolean(props.getProperty("io.nats.client.secure")));
        }
        if (props.containsKey("io.nats.client.tls.debug")) {
            this.setTlsDebug(Boolean.parseBoolean(props.getProperty("io.nats.client.tls.debug")));
        }
        if (props.containsKey("io.nats.client.reconnect.allowed")) {
            this.setReconnectAllowed(Boolean.parseBoolean(props.getProperty("io.nats.client.reconnect.allowed", Boolean.toString(true))));
        }
        if (props.containsKey("io.nats.client.reconnect.max")) {
            this.setMaxReconnect(Integer.parseInt(props.getProperty("io.nats.client.reconnect.max", Integer.toString(60))));
        }
        if (props.containsKey("io.nats.client.reconnect.wait")) {
            this.setReconnectWait(Integer.parseInt(props.getProperty("io.nats.client.reconnect.wait", Integer.toString(2000))));
        }
        if (props.containsKey("io.nats.client.reconnect.buffer.size")) {
            this.setReconnectBufSize(Integer.parseInt(props.getProperty("io.nats.client.reconnect.buffer.size", Integer.toString(0x800000))));
        }
        if (props.containsKey("io.nats.client.timeout")) {
            this.setConnectionTimeout(Integer.parseInt(props.getProperty("io.nats.client.timeout", Integer.toString(2000))));
        }
        if (props.containsKey("io.nats.client.pinginterval")) {
            this.setPingInterval(Integer.parseInt(props.getProperty("io.nats.client.pinginterval", Integer.toString(120000))));
        }
        if (props.containsKey("io.nats.client.maxpings")) {
            this.setMaxPingsOut(Integer.parseInt(props.getProperty("io.nats.client.maxpings", Integer.toString(2))));
        }
        if (props.containsKey("io.nats.client.callback.exception")) {
            instance = null;
            try {
                str = props.getProperty("io.nats.client.callback.exception");
                clazz = Class.forName(str);
                constructor = clazz.getConstructor(new Class[0]);
                instance = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            this.setExceptionHandler(instance);
        }
        if (props.containsKey("io.nats.client.callback.closed")) {
            instance = null;
            try {
                str = props.getProperty("io.nats.client.callback.closed");
                clazz = Class.forName(str);
                constructor = clazz.getConstructor(new Class[0]);
                instance = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            this.setClosedCallback(instance);
        }
        if (props.containsKey("io.nats.client.callback.disconnected")) {
            instance = null;
            try {
                str = props.getProperty("io.nats.client.callback.disconnected");
                clazz = Class.forName(str);
                constructor = clazz.getConstructor(new Class[0]);
                instance = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            this.setDisconnectedCallback(instance);
        }
        if (props.containsKey("io.nats.client.callback.reconnected")) {
            instance = null;
            try {
                str = props.getProperty("io.nats.client.callback.reconnected");
                clazz = Class.forName(str);
                constructor = clazz.getConstructor(new Class[0]);
                instance = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            this.setReconnectedCallback(instance);
        }
        if (props.containsKey("io.nats.client.maxpending")) {
            this.setMaxPendingMsgs(Integer.parseInt(props.getProperty("io.nats.client.maxpending", Integer.toString(65536))));
        }
        if (props.containsKey("io.nats.client.maxpending.bytes")) {
            this.setMaxPendingBytes(Long.parseLong(props.getProperty("io.nats.client.maxpending.bytes", Long.toString(0x4000000L))));
        }
    }

    public ConnectionFactory() {
        this(null, null);
    }

    public ConnectionFactory(String url) {
        this(url, null);
    }

    public ConnectionFactory(String[] servers) {
        this(null, servers);
    }

    public ConnectionFactory(String url, String[] servers) {
        if (url != null && url.contains(",")) {
            this.setServers(url);
        } else {
            this.setUrl(url);
            this.setServers(servers);
        }
    }

    public ConnectionFactory(ConnectionFactory cf) {
        this.url = cf.url;
        this.host = cf.host;
        this.port = cf.port;
        this.username = cf.username;
        this.password = cf.password;
        if (cf.servers != null) {
            this.servers = new ArrayList<URI>(cf.servers);
        }
        this.noRandomize = cf.noRandomize;
        this.connectionName = cf.connectionName;
        this.verbose = cf.verbose;
        this.pedantic = cf.pedantic;
        this.secure = cf.secure;
        this.reconnectAllowed = cf.reconnectAllowed;
        this.maxReconnect = cf.maxReconnect;
        this.reconnectBufSize = cf.reconnectBufSize;
        this.reconnectWait = cf.reconnectWait;
        this.connectionTimeout = cf.connectionTimeout;
        this.pingInterval = cf.pingInterval;
        this.maxPingsOut = cf.maxPingsOut;
        this.sslContext = cf.sslContext;
        this.exceptionHandler = cf.exceptionHandler;
        this.closedCallback = cf.closedCallback;
        this.disconnectedCallback = cf.disconnectedCallback;
        this.reconnectedCallback = cf.reconnectedCallback;
        this.urlString = cf.urlString;
        this.maxPendingMsgs = cf.maxPendingMsgs;
        this.tlsDebug = cf.tlsDebug;
    }

    public Connection createConnection() throws IOException, TimeoutException {
        return this.createConnection(null);
    }

    ConnectionImpl createConnection(TCPConnection tcpconn) throws IOException, TimeoutException {
        ConnectionImpl conn = null;
        Options options = this.options();
        conn = new ConnectionImpl(options, tcpconn);
        conn.connect();
        return conn;
    }

    protected URI constructURI() {
        URI res = null;
        if (this.url != null) {
            res = this.url;
        } else {
            String str = null;
            if (this.getHost() != null) {
                str = "nats://";
                if (this.getUsername() != null) {
                    str = str.concat(this.getUsername());
                    if (this.getPassword() != null) {
                        str = str.concat(":" + this.getPassword());
                    }
                    str = str.concat("@");
                }
                str = str.concat(this.getHost() + ":");
                str = this.getPort() > -1 ? str.concat(String.valueOf(this.getPort())) : str.concat(String.valueOf(4222));
                res = URI.create(str);
            }
        }
        return res;
    }

    protected Options options() {
        Options result = new Options();
        this.url = this.constructURI();
        result.setUrl(this.url);
        result.setHost(this.host);
        result.setPort(this.port);
        result.setPassword(this.password);
        result.setServers(this.servers);
        result.setNoRandomize(this.noRandomize);
        result.setConnectionName(this.connectionName);
        result.setVerbose(this.verbose);
        result.setPedantic(this.pedantic);
        result.setSecure(this.secure);
        result.setTlsDebug(this.tlsDebug);
        result.setReconnectAllowed(this.reconnectAllowed);
        result.setMaxReconnect(this.maxReconnect);
        result.setReconnectBufSize(this.reconnectBufSize);
        result.setReconnectWait(this.reconnectWait);
        result.setConnectionTimeout(this.connectionTimeout);
        result.setPingInterval(this.pingInterval);
        result.setMaxPingsOut(this.maxPingsOut);
        result.setExceptionHandler(this.exceptionHandler);
        result.setClosedCallback(this.closedCallback);
        result.setDisconnectedCallback(this.disconnectedCallback);
        result.setReconnectedCallback(this.reconnectedCallback);
        result.setMaxPendingMsgs(this.maxPendingMsgs);
        result.setSSLContext(this.sslContext);
        return result;
    }

    public int getMaxPendingMsgs() {
        return this.maxPendingMsgs;
    }

    public void setMaxPendingMsgs(int max) {
        this.maxPendingMsgs = max;
    }

    public long getMaxPendingBytes() {
        return this.maxPendingBytes;
    }

    public void setMaxPendingBytes(long max) {
        this.maxPendingBytes = max;
    }

    public ConnectionFactory clone() {
        return new ConnectionFactory(this);
    }

    public void setUri(URI uri) {
        String[] userpass;
        String userInfo;
        int port;
        this.url = uri;
        String scheme = uri.getScheme().toLowerCase();
        if (!("nats".equals(scheme) || "tcp".equals(scheme) || "tls".equals(scheme))) {
            throw new IllegalArgumentException("Wrong scheme in NATS URI: " + uri.getScheme());
        }
        String host = uri.getHost();
        if (host != null) {
            this.setHost(host);
        }
        if ((port = uri.getPort()) != -1) {
            this.setPort(port);
        }
        if ((userInfo = uri.getUserInfo()) != null && (userpass = userInfo.split(":"))[0].length() > 0) {
            this.setUsername(userpass[0]);
            switch (userpass.length) {
                case 1: {
                    break;
                }
                case 2: {
                    this.setPassword(userpass[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad user info in NATS URI: " + userInfo);
                }
            }
        }
    }

    public String getUrlString() {
        return this.urlString;
    }

    public void setUrl(String url) {
        if (url == null) {
            this.url = null;
        } else if (url.contains(",")) {
            this.setServers(url);
        } else {
            try {
                this.setUri(new URI(url));
            }
            catch (NullPointerException | URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            this.urlString = this.url.toString();
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<URI> getServers() {
        return this.servers;
    }

    public void setServers(List<URI> servers) {
        this.servers = servers;
    }

    public void setServers(String urlString) {
        String[] servers = urlString.trim().split("\\s*,\\s*");
        this.setServers(servers);
    }

    public void setServers(String[] servers) {
        if (servers == null) {
            this.servers = null;
        } else {
            if (this.servers == null) {
                this.servers = new ArrayList<URI>();
            }
            this.servers.clear();
            for (String s : servers) {
                try {
                    this.servers.add(new URI(s.trim()));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    public boolean isNoRandomize() {
        return this.noRandomize;
    }

    public void setNoRandomize(boolean noRandomize) {
        this.noRandomize = noRandomize;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isPedantic() {
        return this.pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isTlsDebug() {
        return this.tlsDebug;
    }

    public void setTlsDebug(boolean debug) {
        this.tlsDebug = debug;
    }

    public boolean isReconnectAllowed() {
        return this.reconnectAllowed;
    }

    public void setReconnectAllowed(boolean reconnectAllowed) {
        this.reconnectAllowed = reconnectAllowed;
    }

    public int getMaxReconnect() {
        return this.maxReconnect;
    }

    public void setMaxReconnect(int max) {
        this.maxReconnect = max;
    }

    public long getReconnectWait() {
        return this.reconnectWait;
    }

    public void setReconnectBufSize(int size) {
        this.reconnectBufSize = size <= 0 ? 0x800000 : size;
    }

    public long getReconnectBufSize() {
        return this.reconnectBufSize;
    }

    public void setReconnectWait(long interval) {
        this.reconnectWait = interval;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("TCP connection timeout cannot be negative");
        }
        this.connectionTimeout = timeout;
    }

    public long getPingInterval() {
        return this.pingInterval;
    }

    public void setPingInterval(long interval) {
        this.pingInterval = interval;
    }

    public int getMaxPingsOut() {
        return this.maxPingsOut;
    }

    public void setMaxPingsOut(int max) {
        this.maxPingsOut = max;
    }

    public ClosedCallback getClosedCallback() {
        return this.closedCallback;
    }

    public void setClosedCallback(ClosedCallback cb) {
        this.closedCallback = cb;
    }

    public DisconnectedCallback getDisconnectedCallback() {
        return this.disconnectedCallback;
    }

    public void setDisconnectedCallback(DisconnectedCallback cb) {
        this.disconnectedCallback = cb;
    }

    public ReconnectedCallback getReconnectedCallback() {
        return this.reconnectedCallback;
    }

    public void setReconnectedCallback(ReconnectedCallback cb) {
        this.reconnectedCallback = cb;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("ExceptionHandler cannot be null!");
        }
        this.exceptionHandler = exceptionHandler;
    }

    @Deprecated
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Deprecated
    public void setSslContext(SSLContext ctx) {
        this.setSSLContext(ctx);
    }

    public void setSSLContext(SSLContext ctx) {
        this.sslContext = ctx;
    }
}

