/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Channel;
import io.nats.client.ConnectionImpl;
import io.nats.client.Message;
import io.nats.client.SubscriptionImpl;
import io.nats.client.SyncSubscription;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class SyncSubscriptionImpl
extends SubscriptionImpl
implements SyncSubscription {
    protected SyncSubscriptionImpl(ConnectionImpl nc, String subj, String queue, int maxMsgs, long maxBytes) {
        super(nc, subj, queue, maxMsgs, maxBytes);
    }

    @Override
    public Message nextMessage() throws IOException {
        Message m = null;
        try {
            m = this.nextMessage(-1L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return m;
    }

    @Override
    public Message nextMessage(long timeout) throws IOException, TimeoutException {
        return this.nextMessage(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Message nextMessage(long timeout, TimeUnit unit) throws IOException, TimeoutException {
        Message msg = null;
        this.mu.lock();
        if (this.connClosed) {
            this.mu.unlock();
            throw new IllegalStateException("nats: connection closed");
        }
        if (this.mch == null) {
            if (this.max > 0L && this.delivered.get() >= this.max) {
                this.mu.unlock();
                throw new IOException("nats: maximum messages delivered");
            }
            if (this.closed) {
                this.mu.unlock();
                throw new IllegalStateException("nats: invalid subscription");
            }
        }
        if (this.sc) {
            this.sc = false;
            this.mu.unlock();
            throw new IOException("nats: slow consumer, messages dropped");
        }
        ConnectionImpl localConn = (ConnectionImpl)this.getConnection();
        Channel localChannel = this.mch;
        long localMax = this.max;
        this.mu.unlock();
        if (timeout >= 0L) {
            this.logger.trace("Calling Channel.get({}, {}) for {}", new Object[]{timeout, unit, this.subject});
            msg = (Message)localChannel.get(timeout, unit);
        } else {
            msg = (Message)localChannel.get();
        }
        if (msg != null) {
            long d = this.delivered.incrementAndGet();
            if (d == localMax) {
                localConn.mu.lock();
                localConn.removeSub(this);
                localConn.mu.unlock();
            }
            if (localMax > 0L && d > localMax) {
                throw new IOException("nats: maximum messages delivered");
            }
        }
        return msg;
    }
}

