/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Channel;
import io.nats.client.Connection;
import io.nats.client.ConnectionImpl;
import io.nats.client.Message;
import io.nats.client.Subscription;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SubscriptionImpl
implements Subscription {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    final Lock mu = new ReentrantLock();
    long sid;
    String subject = null;
    String queue;
    long msgs;
    AtomicLong delivered = new AtomicLong();
    long bytes;
    long max;
    protected boolean closed;
    protected boolean connClosed;
    boolean sc;
    ConnectionImpl conn = null;
    Channel<Message> mch;
    int pMsgs;
    int pBytes;
    int pMsgsMax;
    int pBytesMax;
    int pMsgsLimit = 65536;
    long pBytesLimit = this.pMsgsLimit * 1024;
    int dropped;

    SubscriptionImpl(ConnectionImpl conn, String subject, String queue, int maxPendingMsgs, long maxPendingBytes) {
        this.conn = conn;
        this.subject = subject;
        this.queue = queue;
        this.setMaxPendingMsgs(maxPendingMsgs);
        this.mch = new Channel();
    }

    void closeChannel() {
        this.mu.lock();
        try {
            if (this.mch != null) {
                this.mch.close();
                this.mch = null;
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    public Channel<Message> getChannel() {
        return this.mch;
    }

    public void setChannel(Channel<Message> ch) {
        this.mch = ch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tallyMessage(long length) {
        this.mu.lock();
        try {
            if (this.max > 0L && this.msgs > this.max) {
                boolean bl = true;
                return bl;
            }
            ++this.msgs;
            this.bytes += this.bytes;
        }
        finally {
            this.mu.unlock();
        }
        return false;
    }

    protected void handleSlowConsumer(Message msg) {
        ++this.dropped;
        this.conn.processSlowConsumer(this);
        --this.pMsgs;
        if (msg.getData() != null) {
            this.pBytes -= msg.getData().length;
        }
    }

    protected long tallyDeliveredMessage(Message msg) {
        this.delivered.incrementAndGet();
        if (msg.getData() != null) {
            this.pBytes -= msg.getData().length;
        }
        --this.pMsgs;
        return this.delivered.get();
    }

    boolean addMessage(Message m) {
        ++this.pMsgs;
        if (this.pMsgs > this.pMsgsMax) {
            this.pMsgsMax = this.pMsgs;
        }
        if (m.getData() != null) {
            this.pBytes += m.getData().length;
        }
        if (this.pBytes > this.pBytesMax) {
            this.pBytesMax = this.pBytes;
        }
        if (this.pMsgs > this.pMsgsLimit || (long)this.pBytes > this.pBytesLimit) {
            this.handleSlowConsumer(m);
            return false;
        }
        if (this.mch != null) {
            if (this.mch.getCount() >= this.getMaxPendingMsgs()) {
                this.handleSlowConsumer(m);
                return false;
            }
            this.sc = false;
            this.mch.add(m);
        }
        return true;
    }

    @Override
    public boolean isValid() {
        this.mu.lock();
        try {
            boolean bl = this.conn != null;
            return bl;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public void unsubscribe() throws IOException {
        ConnectionImpl c;
        this.mu.lock();
        try {
            c = this.conn;
        }
        finally {
            this.mu.unlock();
        }
        if (c == null) {
            throw new IllegalStateException("nats: invalid subscription");
        }
        c.unsubscribe(this, 0);
    }

    @Override
    public void autoUnsubscribe(int max) throws IOException {
        ConnectionImpl c = null;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            c = this.conn;
        }
        finally {
            this.mu.unlock();
        }
        c.unsubscribe(this, max);
    }

    @Override
    public void close() {
        try {
            this.logger.trace("Calling unsubscribe from AutoCloseable.close()");
            this.unsubscribe();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected long getSid() {
        return this.sid;
    }

    protected void setSid(long id) {
        this.sid = id;
    }

    @Override
    public int getMaxPendingMsgs() {
        return this.pMsgsLimit;
    }

    @Override
    public long getMaxPendingBytes() {
        return this.pBytesLimit;
    }

    @Override
    public void setPendingLimits(int msgs, int bytes) {
        this.setMaxPendingMsgs(msgs);
        this.setMaxPendingBytes(bytes);
    }

    @Override
    public void setMaxPendingMsgs(int pending) {
        this.pMsgsLimit = pending;
        if (pending <= 0) {
            this.pMsgsLimit = 65536;
        }
    }

    @Override
    public void setMaxPendingBytes(long pending) {
        this.pBytesLimit = pending;
        if (pending <= 0L) {
            this.pBytesLimit = 0x4000000L;
        }
    }

    protected Connection getConnection() {
        return this.conn;
    }

    protected void setConnection(ConnectionImpl conn) {
        this.conn = conn;
    }

    @Override
    public int getQueuedMessageCount() {
        if (this.mch != null) {
            return this.mch.getCount();
        }
        return 0;
    }

    public String toString() {
        String s = String.format("{subject=%s, queue=%s, sid=%d, max=%d, delivered=%d, queued=%d, maxPendingMsgs=%d, maxPendingBytes=%d, valid=%b}", this.getSubject(), this.getQueue() == null ? "null" : this.getQueue(), this.getSid(), this.getMax(), this.delivered.get(), this.getQueuedMessageCount(), this.getMaxPendingMsgs(), this.getMaxPendingBytes(), this.isValid());
        return s;
    }

    protected void setSlowConsumer(boolean sc) {
        this.sc = sc;
    }

    protected boolean isSlowConsumer() {
        return this.sc;
    }

    protected boolean processMsg(Message msg) {
        return true;
    }

    protected void setMax(long max) {
        this.max = max;
    }

    protected long getMax() {
        return this.max;
    }

    Lock getLock() {
        return this.mu;
    }
}

