/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NATSThread
extends Thread {
    public static final String DEFAULT_NAME = "NATSThread";
    private static volatile boolean debugLifecycle = false;
    private static final AtomicInteger created = new AtomicInteger();
    private static final AtomicInteger alive = new AtomicInteger();
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;
    private final Logger logger = LoggerFactory.getLogger(NATSThread.class);

    public NATSThread(Runnable r) {
        this(r, DEFAULT_NAME);
    }

    public NATSThread(Runnable runnable, String name) {
        super(runnable, name + "-" + created.incrementAndGet());
        this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                NATSThread.this.logger.debug("UNCAUGHT in thread {}", (Object)t.getName(), (Object)e);
            }
        });
    }

    public NATSThread(Runnable r, String poolName, CountDownLatch startSignal, CountDownLatch doneSignal) {
        super(r, poolName);
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
    }

    @Override
    public void run() {
        this.logger.trace("In RUN");
        boolean debug = debugLifecycle;
        if (debug) {
            this.logger.debug("Created {}", (Object)this.getName());
        }
        try {
            if (this.startSignal != null) {
                this.startSignal.await();
            }
            alive.incrementAndGet();
            super.run();
        }
        catch (InterruptedException e) {
            this.logger.trace("Interrupted: ", (Throwable)e);
        }
        finally {
            if (this.doneSignal != null) {
                this.doneSignal.countDown();
            }
            alive.decrementAndGet();
            if (debug) {
                this.logger.debug("Exiting {}" + this.getName());
            }
        }
    }

    public static int getThreadsCreated() {
        return created.get();
    }

    public static int getThreadsAlive() {
        return alive.get();
    }

    public static boolean getDebug() {
        return debugLifecycle;
    }

    public static void setDebug(boolean b) {
        debugLifecycle = b;
    }
}

