/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NUID {
    static final Logger logger = LoggerFactory.getLogger(NUID.class);
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    static final int base = 36;
    static final int preLen = 12;
    static final int seqLen = 10;
    static final long maxPre = 4738381338321616896L;
    static final long maxSeq = 3656158440062976L;
    static final long minInc = 33L;
    static final long maxInc = 333L;
    static final int totalLen = 22;
    static Random srand;
    static Random prand;
    char[] pre;
    long seq;
    long inc;
    public static NUID globalNUID;
    private static Object lock;

    static NUID getInstance() {
        if (globalNUID == null) {
            globalNUID = new NUID();
        }
        return globalNUID;
    }

    public NUID() {
        if (srand == null) {
            try {
                srand = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                logger.error("stan: nuid algorithm not found", (Throwable)e);
            }
            prand = new Random();
        }
        this.seq = NUID.nextLong(prand, 3656158440062976L);
        this.inc = 33L + NUID.nextLong(prand, 300L);
        this.pre = new char[12];
        for (int i = 0; i < 12; ++i) {
            this.pre[i] = 48;
        }
        this.randomizePrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String nextGlobal() {
        Object object = lock;
        synchronized (object) {
            return NUID.getInstance().next();
        }
    }

    public String next() {
        this.seq += this.inc;
        if (this.seq >= 3656158440062976L) {
            this.randomizePrefix();
            this.resetSequential();
        }
        char[] b = new char[22];
        System.arraycopy(this.pre, 0, b, 0, 12);
        int i = b.length;
        long l = this.seq;
        while (i > 12) {
            b[--i] = digits[(int)(l % 36L)];
            l /= 36L;
        }
        return new String(b);
    }

    void resetSequential() {
        this.seq = NUID.nextLong(prand, 3656158440062976L);
        this.inc = 33L + NUID.nextLong(prand, 300L);
    }

    public void randomizePrefix() {
        long n = NUID.nextLong(srand, 4738381338321616896L);
        int i = this.pre.length;
        long l = n;
        while (i > 0) {
            this.pre[--i] = digits[(int)(l % 36L)];
            l /= 36L;
        }
    }

    static long nextLong(Random rng, long n) {
        long val;
        long bits;
        while ((bits = rng.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    char[] getPre() {
        return this.pre;
    }

    void setPre(char[] pre) {
        this.pre = pre;
    }

    long getSeq() {
        return this.seq;
    }

    void setSeq(long seq) {
        this.seq = seq;
    }

    long getInc() {
        return this.inc;
    }

    void setInc(long inc) {
        this.inc = inc;
    }

    static {
        globalNUID = new NUID();
        lock = new Object();
    }
}

