/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.ConnectionImpl;
import java.nio.ByteBuffer;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Parser {
    static final Logger logger = LoggerFactory.getLogger(Parser.class);
    static final int MAX_CONTROL_LINE_SIZE = 1024;
    static final int MAX_MSG_ARGS = 4;
    private ConnectionImpl nc;
    ParseState ps = new ParseState();
    static final int ascii_0 = 48;
    static final int ascii_9 = 57;

    protected Parser(ConnectionImpl conn) {
        this.nc = conn;
        this.nc.ps = conn.ps;
    }

    protected void parse(byte[] buf, int len) throws ParseException {
        int i;
        boolean error = false;
        block101: for (i = 0; i < len; ++i) {
            byte b = buf[i];
            block0 : switch (this.ps.state) {
                case OP_START: {
                    switch (b) {
                        case 77: 
                        case 109: {
                            this.ps.state = NatsOp.OP_M;
                            break block0;
                        }
                        case 80: 
                        case 112: {
                            this.ps.state = NatsOp.OP_P;
                            break block0;
                        }
                        case 43: {
                            this.ps.state = NatsOp.OP_PLUS;
                            break block0;
                        }
                        case 45: {
                            this.ps.state = NatsOp.OP_MINUS;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_M: {
                    switch (b) {
                        case 83: 
                        case 115: {
                            this.ps.state = NatsOp.OP_MS;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_MS: {
                    switch (b) {
                        case 71: 
                        case 103: {
                            this.ps.state = NatsOp.OP_MSG;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_MSG: {
                    switch (b) {
                        case 9: 
                        case 32: {
                            this.ps.state = NatsOp.OP_MSG_SPC;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_MSG_SPC: {
                    switch (b) {
                        case 9: 
                        case 32: {
                            continue block101;
                        }
                        default: {
                            this.ps.state = NatsOp.MSG_ARG;
                            this.ps.as = i;
                            break;
                        }
                    }
                    break;
                }
                case MSG_ARG: {
                    switch (b) {
                        case 13: {
                            this.ps.drop = 1;
                            break block0;
                        }
                        case 10: {
                            ByteBuffer arg = null;
                            if (this.ps.argBuf != null) {
                                arg = this.ps.argBuf;
                                arg.flip();
                                this.processMsgArgs(arg.array(), arg.arrayOffset(), arg.limit());
                            } else {
                                this.processMsgArgs(buf, this.ps.as, i - this.ps.drop - this.ps.as);
                            }
                            this.ps.drop = 0;
                            this.ps.as = i + 1;
                            this.ps.state = NatsOp.MSG_PAYLOAD;
                            i = this.ps.as + this.ps.ma.size - 1;
                            break block0;
                        }
                    }
                    if (this.ps.argBuf == null) break;
                    this.ps.argBuf.put(b);
                    break;
                }
                case MSG_PAYLOAD: {
                    boolean done = false;
                    if (this.ps.msgBuf != null) {
                        if (this.ps.msgBuf.position() >= this.ps.ma.size) {
                            this.ps.msgBuf.flip();
                            this.nc.processMsg(this.ps.msgBuf.array(), 0, this.ps.msgBuf.limit());
                            done = true;
                        } else {
                            int avail = len - i;
                            int toCopy = this.ps.ma.size - this.ps.msgBuf.limit();
                            if (avail < toCopy) {
                                toCopy = avail;
                            }
                            if (toCopy > 0) {
                                this.ps.msgBuf.put(buf, i, toCopy);
                                i += toCopy - 1;
                            } else {
                                this.ps.msgBuf.put(b);
                            }
                        }
                    } else if (i - this.ps.as >= this.ps.ma.size) {
                        this.nc.processMsg(buf, this.ps.as, i - this.ps.as);
                        done = true;
                    }
                    if (!done) break;
                    this.ps.argBuf = null;
                    this.ps.msgBuf = null;
                    this.ps.state = NatsOp.MSG_END;
                    break;
                }
                case MSG_END: {
                    switch (b) {
                        case 10: {
                            this.ps.drop = 0;
                            this.ps.as = i + 1;
                            this.ps.state = NatsOp.OP_START;
                            break block0;
                        }
                    }
                    continue block101;
                }
                case OP_PLUS: {
                    switch (b) {
                        case 79: 
                        case 111: {
                            this.ps.state = NatsOp.OP_PLUS_O;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_PLUS_O: {
                    switch (b) {
                        case 75: 
                        case 107: {
                            this.ps.state = NatsOp.OP_PLUS_OK;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_PLUS_OK: {
                    switch (b) {
                        case 10: {
                            this.nc.processOK();
                            this.ps.drop = 0;
                            this.ps.state = NatsOp.OP_START;
                        }
                    }
                    break;
                }
                case OP_MINUS: {
                    switch (b) {
                        case 69: 
                        case 101: {
                            this.ps.state = NatsOp.OP_MINUS_E;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_MINUS_E: {
                    switch (b) {
                        case 82: 
                        case 114: {
                            this.ps.state = NatsOp.OP_MINUS_ER;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_MINUS_ER: {
                    switch (b) {
                        case 82: 
                        case 114: {
                            this.ps.state = NatsOp.OP_MINUS_ERR;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_MINUS_ERR: {
                    switch (b) {
                        case 9: 
                        case 32: {
                            this.ps.state = NatsOp.OP_MINUS_ERR_SPC;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_MINUS_ERR_SPC: {
                    switch (b) {
                        case 9: 
                        case 32: {
                            continue block101;
                        }
                        default: {
                            this.ps.state = NatsOp.MINUS_ERR_ARG;
                            this.ps.as = i;
                            break;
                        }
                    }
                    break;
                }
                case MINUS_ERR_ARG: {
                    switch (b) {
                        case 13: {
                            this.ps.drop = 1;
                            break block0;
                        }
                        case 10: {
                            ByteBuffer arg = null;
                            if (this.ps.argBuf != null) {
                                arg = this.ps.argBuf;
                                this.ps.argBuf = null;
                            } else {
                                arg = ByteBuffer.wrap(buf, this.ps.as, i - this.ps.as);
                            }
                            this.nc.processErr(arg);
                            this.ps.drop = 0;
                            this.ps.as = i + 1;
                            this.ps.state = NatsOp.OP_START;
                            break block0;
                        }
                    }
                    if (this.ps.argBuf == null) break;
                    this.ps.argBuf.put(b);
                    break;
                }
                case OP_P: {
                    switch (b) {
                        case 73: 
                        case 105: {
                            this.ps.state = NatsOp.OP_PI;
                            break block0;
                        }
                        case 79: 
                        case 111: {
                            this.ps.state = NatsOp.OP_PO;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_PO: {
                    switch (b) {
                        case 78: 
                        case 110: {
                            this.ps.state = NatsOp.OP_PON;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_PON: {
                    switch (b) {
                        case 71: 
                        case 103: {
                            this.ps.state = NatsOp.OP_PONG;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_PONG: {
                    switch (b) {
                        case 10: {
                            this.nc.processPong();
                            this.ps.drop = 0;
                            this.ps.state = NatsOp.OP_START;
                            break block0;
                        }
                    }
                    break;
                }
                case OP_PI: {
                    switch (b) {
                        case 78: 
                        case 110: {
                            this.ps.state = NatsOp.OP_PIN;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_PIN: {
                    switch (b) {
                        case 71: 
                        case 103: {
                            this.ps.state = NatsOp.OP_PING;
                            break block0;
                        }
                    }
                    error = true;
                    break;
                }
                case OP_PING: {
                    switch (b) {
                        case 10: {
                            this.nc.processPing();
                            this.ps.drop = 0;
                            this.ps.state = NatsOp.OP_START;
                        }
                    }
                    break;
                }
                default: {
                    error = true;
                }
            }
            if (!error) continue;
            error = false;
            throw new ParseException(String.format("nats: parse error [%s]: '%s'", new Object[]{this.ps.state, new String(buf, i, len - i)}), i);
        }
        if ((this.ps.state == NatsOp.MSG_ARG || this.ps.state == NatsOp.MINUS_ERR_ARG) && this.ps.argBuf == null) {
            this.ps.argBuf = ByteBuffer.wrap(this.ps.argBufStore);
            this.ps.argBuf.put(buf, this.ps.as, i - this.ps.drop - this.ps.as);
        }
        if (this.ps.state == NatsOp.MSG_PAYLOAD && this.ps.msgBuf == null) {
            if (this.ps.argBuf == null) {
                this.cloneMsgArg();
            }
            int lrem = len - this.ps.as;
            if (this.ps.ma.size > this.ps.msgBufStore.length) {
                this.ps.msgBufStore = new byte[this.ps.ma.size];
            }
            this.ps.msgBuf = ByteBuffer.wrap(this.ps.msgBufStore);
            this.ps.msgBuf.put(buf, this.ps.as, lrem);
        }
    }

    protected static String bufToString(ByteBuffer arg) {
        if (arg == null) {
            return null;
        }
        int pos = arg.position();
        int len = arg.limit() - arg.position();
        byte[] stringBytes = new byte[len];
        arg.get(stringBytes, 0, len);
        arg.position(pos);
        String str = new String(stringBytes);
        return str;
    }

    protected void processMsgArgs(byte[] arg, int offset, int length) throws ParseException {
        int i;
        int argLen = 0;
        int numArgs = 0;
        int start = -1;
        block7: for (i = offset; i < offset + length; ++i) {
            byte b = arg[i];
            switch (b) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (start < 0) continue block7;
                    argLen = i - start;
                    if (argLen > this.ps.args[numArgs].remaining()) {
                        this.ps.args[numArgs] = ByteBuffer.allocate(argLen);
                    }
                    this.ps.args[numArgs++].put(arg, start, argLen).flip();
                    start = -1;
                    continue block7;
                }
                default: {
                    if (start >= 0) continue block7;
                    start = i;
                }
            }
        }
        if (start >= 0) {
            argLen = i - start;
            this.ps.args[numArgs++].put(arg, start, argLen).flip();
        }
        this.ps.ma.subject.clear();
        this.ps.ma.reply.clear();
        if (this.ps.ma.subject.remaining() < this.ps.args[0].limit()) {
            this.ps.ma.subject = ByteBuffer.allocate(this.ps.args[0].limit());
        }
        switch (numArgs) {
            case 3: {
                this.ps.ma.subject.put(this.ps.args[0].array(), 0, this.ps.args[0].limit());
                this.ps.ma.sid = Parser.parseLong(this.ps.args[1].array(), this.ps.args[1].limit());
                this.ps.ma.reply.clear();
                this.ps.ma.size = (int)Parser.parseLong(this.ps.args[2].array(), this.ps.args[2].limit());
                break;
            }
            case 4: {
                this.ps.ma.subject.put(this.ps.args[0].array(), 0, this.ps.args[0].limit());
                this.ps.ma.sid = Parser.parseLong(this.ps.args[1].array(), this.ps.args[1].limit());
                if (this.ps.ma.reply.remaining() < this.ps.args[2].limit()) {
                    this.ps.ma.reply = ByteBuffer.allocate(this.ps.args[2].limit());
                }
                this.ps.ma.reply.put(this.ps.args[2].array(), 0, this.ps.args[2].limit());
                this.ps.ma.size = (int)Parser.parseLong(this.ps.args[3].array(), this.ps.args[3].limit());
                break;
            }
            default: {
                String msg = String.format("nats: processMsgArgs bad number of args(%d): '%s'", numArgs, new String(arg, offset, length));
                throw new ParseException(msg, 0);
            }
        }
        for (int n = 0; n < 4; ++n) {
            this.ps.args[n].clear();
        }
        if (this.ps.ma.sid < 0L) {
            String str = new String(arg, offset, length);
            throw new ParseException(String.format("nats: processMsgArgs bad or missing sid: '%s'", str), (int)this.ps.ma.sid);
        }
        if (this.ps.ma.size < 0) {
            String str = new String(arg, offset, length);
            throw new ParseException(String.format("nats: processMsgArgs bad or missing size: '%s'", str), this.ps.ma.size);
        }
        this.ps.ma.subject.flip();
        this.ps.ma.reply.flip();
    }

    private void cloneMsgArg() {
        this.ps.argBuf = ByteBuffer.wrap(this.ps.argBufStore);
        this.ps.argBuf.put(this.ps.ma.subject.array(), 0, this.ps.ma.subject.limit());
        if (this.ps.ma.reply.limit() != 0) {
            this.ps.argBuf.put(this.ps.ma.reply.array(), 0, this.ps.ma.reply.limit());
        }
        this.ps.argBuf.rewind();
        this.ps.argBuf.get(this.ps.ma.subject.array(), 0, this.ps.ma.subject.limit());
        if (this.ps.ma.reply.limit() != 0) {
            this.ps.argBuf.get(this.ps.ma.reply.array(), 0, this.ps.ma.reply.limit());
        }
    }

    static long parseLong(byte[] d, int length) {
        long n = 0L;
        if (length == 0) {
            return -1L;
        }
        for (int i = 0; i < length; ++i) {
            byte dec = d[i];
            if (dec < 48 || dec > 57) {
                return -1L;
            }
            n = n * 10L + (long)dec - 48L;
        }
        return n;
    }

    static enum NatsOp {
        OP_START,
        OP_PLUS,
        OP_PLUS_O,
        OP_PLUS_OK,
        OP_MINUS,
        OP_MINUS_E,
        OP_MINUS_ER,
        OP_MINUS_ERR,
        OP_MINUS_ERR_SPC,
        MINUS_ERR_ARG,
        OP_M,
        OP_MS,
        OP_MSG,
        OP_MSG_SPC,
        MSG_ARG,
        MSG_PAYLOAD,
        MSG_END,
        OP_P,
        OP_PI,
        OP_PIN,
        OP_PING,
        OP_PO,
        OP_PON,
        OP_PONG;

    }

    protected class ParseState {
        NatsOp state = NatsOp.OP_START;
        int as;
        int drop;
        MsgArg ma = new MsgArg();
        byte[] argBufStore = new byte[65536];
        ByteBuffer argBuf = null;
        byte[] msgBufStore = new byte[65536];
        ByteBuffer msgBuf = null;
        ByteBuffer[] args = new ByteBuffer[4];

        ParseState() {
            for (int i = 0; i < 4; ++i) {
                this.args[i] = ByteBuffer.allocate(1024);
            }
        }
    }

    protected class MsgArg {
        ByteBuffer subject = ByteBuffer.allocate(1024);
        ByteBuffer reply = ByteBuffer.allocate(1024);
        long sid;
        int size;

        protected MsgArg() {
        }

        public String toString() {
            return String.format("{subject=%s(len=%d), reply=%s(len=%d), sid=%d, size=%d}", new String(this.subject.array(), 0, this.subject.limit()), this.subject.limit(), this.reply == null ? "null" : new String(this.reply.array(), 0, this.reply.limit()), this.reply.limit(), this.sid, this.size);
        }
    }
}

