/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel<T> {
    static final Logger logger = LoggerFactory.getLogger(Channel.class);
    LinkedBlockingQueue<T> q;
    T defaultVal = null;
    boolean closed = false;

    public Channel() {
        this(-1);
    }

    public Channel(LinkedBlockingQueue<T> queue) {
        this.q = queue;
    }

    public Channel(int capacity) {
        this.q = capacity <= 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(capacity);
    }

    public Channel(Collection<T> collection) {
        this.q = new LinkedBlockingQueue<T>(collection);
    }

    public T get() {
        T result = this.defaultVal;
        try {
            result = this.get(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new Error("Unexpected error: " + e.getMessage());
        }
        return result;
    }

    public synchronized T get(long timeout) throws TimeoutException {
        return this.get(timeout, TimeUnit.MILLISECONDS);
    }

    public T get(long timeout, TimeUnit unit) throws TimeoutException {
        T item = this.defaultVal;
        try {
            if (timeout < 0L) {
                item = this.q.take();
            } else {
                item = this.q.poll(timeout, unit);
                if (item == null) {
                    throw new TimeoutException("Channel timed out waiting for items");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return item;
    }

    public T poll() {
        return this.q.poll();
    }

    public boolean add(T item) {
        if (this.isClosed()) {
            return false;
        }
        return this.q.offer(item);
    }

    public boolean add(T item, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isClosed()) {
            return false;
        }
        return this.q.offer(item, timeout, unit);
    }

    public void close() {
        this.closed = true;
        this.q.clear();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getCount() {
        return this.q.size();
    }
}

