/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;

class ServerInfo {
    @SerializedName(value="server_id")
    private String id;
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="go")
    private String goVersion;
    @SerializedName(value="host")
    private String host;
    @SerializedName(value="port")
    private int port;
    @SerializedName(value="auth_required")
    private boolean authRequired;
    @SerializedName(value="ssl_required")
    private boolean sslRequired;
    @SerializedName(value="tls_required")
    private boolean tlsRequired;
    @SerializedName(value="tls_verify")
    private boolean tlsVerify;
    @SerializedName(value="max_payload")
    private long maxPayload;
    @SerializedName(value="connect_urls")
    private String[] connectUrls;
    private transient String jsonString = null;
    private static transient Gson gson = new GsonBuilder().create();

    protected ServerInfo(String id, String host, int port, String version, boolean authRequired, boolean tlsRequired, int maxPayload, String[] connectUrls) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.version = version;
        this.authRequired = authRequired;
        this.tlsRequired = tlsRequired;
        this.maxPayload = maxPayload;
        this.connectUrls = connectUrls;
    }

    protected ServerInfo(ServerInfo input) {
        this.id = input.id;
        this.version = input.version;
        this.goVersion = input.goVersion;
        this.host = input.host;
        this.port = input.port;
        this.authRequired = input.authRequired;
        this.sslRequired = input.sslRequired;
        this.tlsRequired = input.tlsRequired;
        this.tlsVerify = input.tlsVerify;
        this.maxPayload = input.maxPayload;
        if (input.connectUrls != null) {
            this.connectUrls = Arrays.copyOf(input.connectUrls, input.connectUrls.length);
        }
    }

    protected static ServerInfo createFromWire(String infoString) {
        ServerInfo rv = null;
        String jsonString = infoString.replaceFirst("^INFO ", "").trim();
        rv = (ServerInfo)gson.fromJson(jsonString, ServerInfo.class);
        return rv;
    }

    String getId() {
        return this.id;
    }

    String getHost() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    String getVersion() {
        return this.version;
    }

    boolean isAuthRequired() {
        return this.authRequired;
    }

    boolean isTlsRequired() {
        return this.tlsRequired;
    }

    long getMaxPayload() {
        return this.maxPayload;
    }

    String[] getConnectUrls() {
        return this.connectUrls;
    }

    public String toString() {
        String rv = null;
        if (this.jsonString == null) {
            this.jsonString = gson.toJson((Object)this);
        }
        rv = String.format("INFO %s", this.jsonString);
        return rv;
    }
}

