/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Channel;
import io.nats.client.Connection;
import io.nats.client.ConnectionImpl;
import io.nats.client.Message;
import io.nats.client.Subscription;
import java.io.IOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SubscriptionImpl
implements Subscription {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    static final int DEFAULT_MAX_PENDING_MSGS = 65536;
    static final int DEFAULT_MAX_PENDING_BYTES = 0x4000000;
    final Lock mu = new ReentrantLock();
    long sid;
    String subject = null;
    String queue;
    long msgs;
    long delivered;
    long bytes;
    long max;
    protected boolean closed;
    protected boolean connClosed;
    boolean sc;
    ConnectionImpl conn = null;
    Channel<Message> mch;
    Condition pCond;
    int pMsgs;
    int pBytes;
    int pMsgsMax;
    int pBytesMax;
    int pMsgsLimit = 65536;
    int pBytesLimit = this.pMsgsLimit * 1024;
    int dropped;

    SubscriptionImpl(ConnectionImpl conn, String subject, String queue) {
        this(conn, subject, queue, 65536, 0x4000000);
    }

    SubscriptionImpl(ConnectionImpl conn, String subject, String queue, int pendingMsgsLimit, int pendingBytesLimit) {
        this.conn = conn;
        this.subject = subject;
        this.queue = queue;
        this.setPendingMsgsLimit(pendingMsgsLimit);
        this.setPendingBytesLimit(pendingBytesLimit);
        this.mch = new Channel();
        this.pCond = this.mu.newCondition();
    }

    void closeChannel() {
        this.mu.lock();
        try {
            if (this.mch != null) {
                this.mch.close();
                this.mch = null;
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    public Channel<Message> getChannel() {
        return this.mch;
    }

    public void setChannel(Channel<Message> ch) {
        this.mch = ch;
    }

    @Override
    public boolean isValid() {
        this.mu.lock();
        boolean valid = this.conn != null;
        this.mu.unlock();
        return valid;
    }

    @Override
    public void unsubscribe() throws IOException {
        this.mu.lock();
        ConnectionImpl c = this.conn;
        this.mu.unlock();
        if (c == null) {
            throw new IllegalStateException("nats: invalid subscription");
        }
        c.unsubscribe(this, 0);
    }

    @Override
    public void autoUnsubscribe(int max) throws IOException {
        ConnectionImpl c = null;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            c = this.conn;
        }
        finally {
            this.mu.unlock();
        }
        c.unsubscribe(this, max);
    }

    @Override
    public void close() {
        try {
            this.logger.debug("Calling unsubscribe from AutoCloseable.close()");
            this.unsubscribe();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected long getSid() {
        return this.sid;
    }

    protected void setSid(long id) {
        this.sid = id;
    }

    @Override
    public int getDropped() {
        int rv = 0;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.dropped;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public int getPendingMsgsMax() {
        int rv = 0;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.pMsgsMax;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public long getPendingBytesMax() {
        int rv = 0;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.pBytesMax;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public void setPendingLimits(int msgs, int bytes) {
        this.setPendingMsgsLimit(msgs);
        this.setPendingBytesLimit(bytes);
    }

    void setPendingMsgsLimit(int pendingMsgsLimit) {
        this.mu.lock();
        try {
            this.pMsgsLimit = pendingMsgsLimit;
            if (pendingMsgsLimit == 0) {
                throw new IllegalArgumentException("nats: pending message limit cannot be zero");
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    void setPendingBytesLimit(int pendingBytesLimit) {
        this.mu.lock();
        try {
            this.pBytesLimit = pendingBytesLimit;
            if (pendingBytesLimit == 0) {
                throw new IllegalArgumentException("nats: pending message limit cannot be zero");
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    void setPendingMsgsMax(int max) {
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            this.pMsgsMax = max <= 0 ? 0 : max;
        }
        finally {
            this.mu.unlock();
        }
    }

    void setPendingBytesMax(int max) {
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            this.pBytesMax = max <= 0 ? 0 : max;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public void clearMaxPending() {
        this.setPendingMsgsMax(0);
        this.setPendingBytesMax(0);
    }

    protected Connection getConnection() {
        return this.conn;
    }

    protected void setConnection(ConnectionImpl conn) {
        this.conn = conn;
    }

    @Override
    public long getDelivered() {
        long rv = 0L;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.delivered;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public int getPendingBytes() {
        int rv = 0;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.pBytes;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public int getPendingBytesLimit() {
        int rv = 0;
        this.mu.lock();
        rv = this.pBytesLimit;
        this.mu.unlock();
        return rv;
    }

    @Override
    public int getPendingMsgs() {
        int rv = 0;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.pMsgs;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public int getPendingMsgsLimit() {
        int rv = 0;
        this.mu.lock();
        rv = this.pMsgsLimit;
        this.mu.unlock();
        return rv;
    }

    @Override
    public int getQueuedMessageCount() {
        return this.getPendingMsgs();
    }

    public String toString() {
        String str = String.format("{subject=%s, queue=%s, sid=%d, max=%d, delivered=%d, pendingMsgsLimit=%d, pendingBytesLimit=%d, maxPendingMsgs=%d, maxPendingBytes=%d, valid=%b}", this.getSubject(), this.getQueue() == null ? "null" : this.getQueue(), this.getSid(), this.getMax(), this.delivered, this.getPendingMsgsLimit(), this.getPendingBytesLimit(), this.getPendingMsgsMax(), this.getPendingBytesMax(), this.isValid());
        return str;
    }

    protected void setSlowConsumer(boolean sc) {
        this.sc = sc;
    }

    protected boolean isSlowConsumer() {
        return this.sc;
    }

    protected void setMax(long max) {
        this.max = max;
    }

    protected long getMax() {
        return this.max;
    }

    void lock() {
        this.mu.lock();
    }

    void unlock() {
        this.mu.unlock();
    }

    void printStats() {
        System.err.println("delivered: " + this.delivered);
        System.err.println("dropped: " + this.dropped);
        System.err.println("pMsgs: " + this.pMsgs);
        System.err.println("pMsgsLimit: " + this.pMsgsLimit);
        System.err.println("pMsgsMax: " + this.pMsgsMax);
        System.err.println("pBytes: " + this.pBytes);
        System.err.println("pBytesLimit: " + this.pBytesLimit);
        System.err.println("pBytesMax: " + this.pBytesMax);
        System.err.println();
    }
}

