/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Channel;
import io.nats.client.ConnectionImpl;
import io.nats.client.Message;
import io.nats.client.SubscriptionImpl;
import io.nats.client.SyncSubscription;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class SyncSubscriptionImpl
extends SubscriptionImpl
implements SyncSubscription {
    protected SyncSubscriptionImpl(ConnectionImpl nc, String subj, String queue) {
        super(nc, subj, queue);
    }

    @Override
    public Message nextMessage() throws IOException {
        Message msg = null;
        try {
            msg = this.nextMessage(-1L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return msg;
    }

    @Override
    public Message nextMessage(long timeout) throws IOException, TimeoutException {
        return this.nextMessage(timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message nextMessage(long timeout, TimeUnit unit) throws IOException, TimeoutException {
        this.mu.lock();
        if (this.connClosed) {
            this.mu.unlock();
            throw new IllegalStateException("nats: connection closed");
        }
        if (this.mch == null) {
            if (this.max > 0L && this.delivered >= this.max) {
                this.mu.unlock();
                throw new IOException("nats: maximum messages delivered");
            }
            if (this.closed) {
                this.mu.unlock();
                throw new IllegalStateException("nats: invalid subscription");
            }
        }
        if (this.sc) {
            this.sc = false;
            this.mu.unlock();
            throw new IOException("nats: slow consumer, messages dropped");
        }
        ConnectionImpl localConn = (ConnectionImpl)this.getConnection();
        Channel localChannel = this.mch;
        long localMax = this.max;
        boolean chanClosed = localChannel.isClosed();
        this.mu.unlock();
        Message msg = null;
        if (timeout >= 0L) {
            msg = (Message)localChannel.get(timeout, unit);
        } else {
            msg = (Message)localChannel.get();
        }
        if (msg != null) {
            this.mu.lock();
            ++this.delivered;
            long delivered = this.delivered;
            --this.pMsgs;
            this.pBytes -= msg.getData() != null ? msg.getData().length : 0;
            this.mu.unlock();
            if (localMax > 0L) {
                if (delivered > localMax) {
                    throw new IOException("nats: maximum messages delivered");
                }
                if (delivered == localMax) {
                    localConn.mu.lock();
                    try {
                        localConn.removeSub(this);
                    }
                    finally {
                        localConn.mu.unlock();
                    }
                }
            }
        }
        return msg;
    }
}

