/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import java.util.concurrent.atomic.AtomicLong;

public class Statistics
implements Cloneable {
    private AtomicLong inMsgs = new AtomicLong();
    private AtomicLong outMsgs = new AtomicLong();
    private AtomicLong inBytes = new AtomicLong();
    private AtomicLong outBytes = new AtomicLong();
    private AtomicLong reconnects = new AtomicLong();
    private AtomicLong flushes = new AtomicLong();

    public Statistics() {
    }

    Statistics(Statistics obj) {
        this.inMsgs = obj.inMsgs;
        this.inBytes = obj.inBytes;
        this.outBytes = obj.outBytes;
        this.outMsgs = obj.outMsgs;
        this.reconnects = obj.reconnects;
        this.flushes = obj.flushes;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void clear() {
        this.inBytes.set(0L);
        this.inMsgs.set(0L);
        this.outBytes.set(0L);
        this.outMsgs.set(0L);
        this.flushes.set(0L);
    }

    public String toString() {
        return String.format("{in: msgs=%d, bytes=%d, out: msgs=%d, bytes=%d, reconnects: %d, flushes: %d}", this.inMsgs.get(), this.inBytes.get(), this.outMsgs.get(), this.outBytes.get(), this.reconnects.get(), this.flushes.get());
    }

    public long getInMsgs() {
        return this.inMsgs.get();
    }

    long incrementInMsgs() {
        return this.inMsgs.incrementAndGet();
    }

    public long getOutMsgs() {
        return this.outMsgs.get();
    }

    long incrementOutMsgs() {
        return this.outMsgs.incrementAndGet();
    }

    public long getInBytes() {
        return this.inBytes.get();
    }

    long incrementInBytes(long amount) {
        return this.inBytes.addAndGet(amount);
    }

    public long getOutBytes() {
        return this.outBytes.get();
    }

    long incrementOutBytes(long delta) {
        return this.outBytes.addAndGet(delta);
    }

    public long getReconnects() {
        return this.reconnects.get();
    }

    long incrementReconnects() {
        return this.reconnects.incrementAndGet();
    }

    long getFlushes() {
        return this.flushes.get();
    }

    long incrementFlushes() {
        return this.flushes.incrementAndGet();
    }
}

