/*
 * Decompiled with CFR 0.152.
 */
package io.nats.benchmark;

import io.nats.benchmark.Utils;
import io.nats.client.Connection;
import io.nats.client.Statistics;
import java.text.DecimalFormat;

public class Sample {
    int jobMsgCnt;
    long msgCnt;
    long msgBytes;
    long ioBytes;
    long start;
    long end;
    static final double BILLION = 1.0E9;

    public Sample() {
    }

    public Sample(int jobCount, int msgSize, long start, long end, Connection nc) {
        this.jobMsgCnt = jobCount;
        this.start = start;
        this.end = end;
        this.msgBytes = msgSize * jobCount;
        Statistics stats = nc.getStats();
        this.msgCnt = stats.getOutMsgs() + stats.getInMsgs();
        this.ioBytes = stats.getOutBytes() + stats.getInBytes();
    }

    public long duration() {
        return this.end - this.start;
    }

    public double throughput() {
        return (double)this.msgBytes / ((double)this.duration() / 1.0E9);
    }

    public long rate() {
        return (long)((double)this.jobMsgCnt / ((double)this.duration() / 1.0E9));
    }

    public double seconds() {
        return (double)this.duration() / 1.0E9;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat("#,###");
        String rate = formatter.format(this.rate());
        String throughput = Utils.humanBytes(this.throughput(), false);
        return String.format("%s msgs/sec ~ %s/sec", rate, throughput);
    }
}

