/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.ConnectionImpl;
import io.nats.client.Message;
import io.nats.client.SubscriptionImpl;
import io.nats.client.SyncSubscription;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class SyncSubscriptionImpl
extends SubscriptionImpl
implements SyncSubscription {
    private Map<Long, Thread> threads = new ConcurrentHashMap<Long, Thread>();

    protected SyncSubscriptionImpl(ConnectionImpl nc, String subj, String queue) {
        super(nc, subj, queue);
    }

    @Override
    public void close() {
        super.close();
        this.mu.lock();
        this.logger.debug("In SyncSubscriptionImpl#close()");
        for (long key : this.threads.keySet()) {
            if (key == Thread.currentThread().getId()) continue;
            this.threads.get(key).interrupt();
        }
        this.mu.unlock();
    }

    @Override
    public Message nextMessage() throws IOException, InterruptedException {
        Message msg = null;
        try {
            msg = this.nextMessage(-1L);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return msg;
    }

    @Override
    public Message nextMessage(long timeout) throws IOException, TimeoutException, InterruptedException {
        return this.nextMessage(timeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message nextMessage(long timeout, TimeUnit unit) throws IOException, TimeoutException, InterruptedException {
        this.mu.lock();
        if (this.connClosed) {
            this.mu.unlock();
            throw new IllegalStateException("nats: connection closed");
        }
        if (this.mch == null) {
            if (this.max > 0L && this.delivered >= this.max) {
                this.mu.unlock();
                throw new IOException("nats: maximum messages delivered");
            }
            if (this.closed) {
                this.mu.unlock();
                throw new IllegalStateException("nats: invalid subscription");
            }
        }
        if (this.sc) {
            this.sc = false;
            this.mu.unlock();
            throw new IOException("nats: slow consumer, messages dropped");
        }
        ConnectionImpl localConn = (ConnectionImpl)this.getConnection();
        long localMax = this.max;
        this.mu.unlock();
        Message msg = null;
        this.threads.put(Thread.currentThread().getId(), Thread.currentThread());
        if (timeout >= 0L) {
            msg = (Message)this.mch.poll(timeout, unit);
            if (msg == null) {
                throw new TimeoutException("nats: timeout");
            }
        } else {
            msg = (Message)this.mch.take();
        }
        if (msg != null) {
            this.mu.lock();
            ++this.delivered;
            long delivered = this.delivered;
            --this.pMsgs;
            this.pBytes -= msg.getData() != null ? msg.getData().length : 0;
            this.mu.unlock();
            if (localMax > 0L) {
                if (delivered > localMax) {
                    throw new IOException("nats: maximum messages delivered");
                }
                if (delivered == localMax) {
                    localConn.mu.lock();
                    try {
                        localConn.removeSub(this);
                    }
                    finally {
                        localConn.mu.unlock();
                    }
                }
            }
        }
        return msg;
    }
}

