/*
 * Decompiled with CFR 0.152.
 */
package io.nats.benchmark;

import io.nats.benchmark.Sample;
import io.nats.benchmark.SampleGroup;
import io.nats.client.NUID;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Benchmark
extends Sample {
    String name = null;
    String runId = null;
    SampleGroup pubs = new SampleGroup(new SampleGroup[0]);
    SampleGroup subs = new SampleGroup(new SampleGroup[0]);
    BlockingQueue<Sample> pubChannel = new LinkedBlockingQueue<Sample>();
    BlockingQueue<Sample> subChannel;

    public Benchmark() {
    }

    public Benchmark(String name, int subCnt, int pubCnt) {
        this(name, NUID.nextGlobal(), subCnt, pubCnt);
    }

    public Benchmark(String name, String runId, int subCnt, int pubCnt) {
        this.name = name;
        this.runId = runId;
        this.subChannel = new LinkedBlockingQueue<Sample>();
        this.pubChannel = new LinkedBlockingQueue<Sample>();
    }

    public void addPubSample(Sample sample) {
        this.pubChannel.add(sample);
    }

    public void addSubSample(Sample sample) {
        this.subChannel.add(sample);
    }

    public void close() {
        while (this.subChannel.size() > 0) {
            this.subs.addSample((Sample)this.subChannel.poll());
        }
        while (this.pubChannel.size() > 0) {
            this.pubs.addSample((Sample)this.pubChannel.poll());
        }
        if (this.subs.hasSamples()) {
            this.start = this.subs.start;
            this.end = this.subs.end;
        } else {
            this.start = this.pubs.start;
            this.end = this.pubs.end;
        }
        this.end = Math.min(this.end, this.subs.end);
        this.end = Math.min(this.end, this.pubs.end);
        this.msgBytes = this.pubs.msgBytes + this.subs.msgBytes;
        this.ioBytes = this.pubs.ioBytes + this.subs.ioBytes;
        this.msgCnt = this.pubs.msgCnt + this.subs.msgCnt;
        this.jobMsgCnt = this.pubs.jobMsgCnt + this.subs.jobMsgCnt;
    }

    public String report() {
        String maybeTitle;
        StringBuffer sb = new StringBuffer();
        String indent = "";
        if (this.pubs.hasSamples() && this.subs.hasSamples()) {
            sb.append(String.format("%s Pub/Sub stats: %s\n", this.name, this));
            indent = indent + " ";
        }
        if (this.pubs.hasSamples()) {
            maybeTitle = "";
            if (!this.subs.hasSamples()) {
                maybeTitle = this.name + " ";
            }
            sb.append(String.format("%s%sPub stats: %s\n", indent, maybeTitle, this.pubs));
            if (this.pubs.samples.size() > 1) {
                for (Sample stat : this.pubs.samples) {
                    sb.append(String.format("%s [%d] %s (%d msgs)\n", indent, this.pubs.samples.indexOf(stat) + 1, stat, stat.jobMsgCnt));
                }
                sb.append(String.format("%s %s\n", indent, this.pubs.statistics()));
            }
        }
        if (this.subs.hasSamples()) {
            maybeTitle = "";
            sb.append(String.format("%s%sSub stats: %s\n", indent, maybeTitle, this.subs));
            if (this.subs.samples.size() > 1) {
                for (Sample stat : this.subs.samples) {
                    sb.append(String.format("%s [%d] %s (%d msgs)\n", indent, this.subs.samples.indexOf(stat) + 1, stat, stat.jobMsgCnt));
                }
                sb.append(String.format("%s %s\n", indent, this.subs.statistics()));
            }
        }
        return sb.toString();
    }

    public List<String> csv() {
        ArrayList<String> lines = new ArrayList<String>();
        String header = "#RunID, ClientID, MsgCount, MsgBytes, MsgsPerSec, BytesPerSec, DurationSecs";
        lines.add(header);
        SampleGroup[] groups = new SampleGroup[]{this.subs, this.pubs};
        String pre = "S";
        int i = 0;
        for (SampleGroup grp : groups) {
            if (i++ == 1) {
                pre = "P";
            }
            int j = 0;
            for (Sample stat : grp.samples) {
                String line = String.format("%s,%s%d,%d,%d,%d,%f,%f", this.runId, pre, j, stat.msgCnt, stat.msgBytes, stat.rate(), stat.throughput(), (double)stat.duration() / 1.0E9);
                lines.add(line);
            }
        }
        return lines;
    }
}

