/*
 * Decompiled with CFR 0.152.
 */
package io.nats.benchmark;

import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static String humanBytes(double bytes, boolean si) {
        int base = 1024;
        String[] pre = new String[]{"K", "M", "G", "T", "P", "E"};
        String post = "B";
        if (si) {
            base = 1000;
            pre = new String[]{"k", "M", "G", "T", "P", "E"};
            post = "iB";
        }
        if (bytes < (double)base) {
            return String.format("%.2f B", bytes);
        }
        int exp = (int)(Math.log(bytes) / Math.log(base));
        int index = exp - 1;
        String units = pre[index] + post;
        return String.format("%.2f %s", bytes / Math.pow(base, exp), units);
    }

    public static List<Integer> msgsPerClient(int numMsgs, int numClients) {
        ArrayList<Integer> counts = new ArrayList<Integer>(numClients);
        if (numClients == 0 || numMsgs == 0) {
            return counts;
        }
        int mc = numMsgs / numClients;
        for (int i = 0; i < numClients; ++i) {
            counts.add(mc);
        }
        int extra = numMsgs % numClients;
        for (int i = 0; i < extra; ++i) {
            counts.set(i, (Integer)counts.get(i) + 1);
        }
        return counts;
    }
}

