/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class NatsServerInfo {
    static final String SERVER_ID = "server_id";
    static final String VERSION = "version";
    static final String GO = "go";
    static final String HOST = "host";
    static final String PORT = "port";
    static final String AUTH = "auth_required";
    static final String TLS = "tls_required";
    static final String MAX_PAYLOAD = "max_payload";
    static final String CONNECT_URLS = "connect_urls";
    private String serverId;
    private String version;
    private String go;
    private String host;
    private int port;
    private boolean authRequired;
    private boolean tlsRequired;
    private long maxPayload;
    private String[] connectURLs;
    private String rawInfoJson;

    public NatsServerInfo(String json) {
        this.rawInfoJson = json;
        this.parseInfo(json);
    }

    public String getServerId() {
        return this.serverId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGoVersion() {
        return this.go;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isTLSRequired() {
        return this.tlsRequired;
    }

    public long getMaxPayload() {
        return this.maxPayload;
    }

    public String[] getConnectURLs() {
        return this.connectURLs;
    }

    public String getRawJson() {
        return this.rawInfoJson;
    }

    void parseInfo(String jsonString) {
        String grabString = "\\s*\"(.+?)\"";
        String grabBoolean = "\\s*(true|false)";
        String grabNumber = "\\s*(\\d+)";
        String grabArray = "\\s*\\[(.+?)\\]";
        String grabObject = "\\{(.+?)\\}";
        Pattern serverIdRE = Pattern.compile("\"server_id\":" + grabString, 2);
        Pattern versionRE = Pattern.compile("\"version\":" + grabString, 2);
        Pattern goRE = Pattern.compile("\"go\":" + grabString, 2);
        Pattern hostRE = Pattern.compile("\"host\":" + grabString, 2);
        Pattern authRE = Pattern.compile("\"auth_required\":" + grabBoolean, 2);
        Pattern tlsRE = Pattern.compile("\"tls_required\":" + grabBoolean, 2);
        Pattern portRE = Pattern.compile("\"port\":" + grabNumber, 2);
        Pattern maxRE = Pattern.compile("\"max_payload\":" + grabNumber, 2);
        Pattern connectRE = Pattern.compile("\"connect_urls\":" + grabArray, 2);
        Pattern infoObject = Pattern.compile(grabObject, 2);
        Matcher m = infoObject.matcher(jsonString);
        if (m.find()) {
            this.rawInfoJson = jsonString = m.group(0);
        } else {
            jsonString = "";
        }
        if (jsonString.length() < 2) {
            throw new IllegalArgumentException("Server info requires at least {}.");
        }
        if (jsonString.charAt(0) != '{' || jsonString.charAt(jsonString.length() - 1) != '}') {
            throw new IllegalArgumentException("Server info should be JSON wrapped with { and }.");
        }
        m = serverIdRE.matcher(jsonString);
        if (m.find()) {
            this.serverId = this.unescapeString(m.group(1));
        }
        if ((m = versionRE.matcher(jsonString)).find()) {
            this.version = this.unescapeString(m.group(1));
        }
        if ((m = goRE.matcher(jsonString)).find()) {
            this.go = this.unescapeString(m.group(1));
        }
        if ((m = hostRE.matcher(jsonString)).find()) {
            this.host = this.unescapeString(m.group(1));
        }
        if ((m = authRE.matcher(jsonString)).find()) {
            this.authRequired = Boolean.parseBoolean(m.group(1));
        }
        if ((m = tlsRE.matcher(jsonString)).find()) {
            this.tlsRequired = Boolean.parseBoolean(m.group(1));
        }
        if ((m = portRE.matcher(jsonString)).find()) {
            this.port = Integer.parseInt(m.group(1));
        }
        if ((m = maxRE.matcher(jsonString)).find()) {
            this.maxPayload = Long.parseLong(m.group(1));
        }
        if ((m = connectRE.matcher(jsonString)).find()) {
            String arrayString = m.group(1);
            String[] raw = arrayString.split(",");
            ArrayList<String> urls = new ArrayList<String>();
            for (String s : raw) {
                String cleaned = s.trim().replace("\"", "");
                if (cleaned.length() <= 0) continue;
                urls.add(cleaned);
            }
            this.connectURLs = urls.toArray(new String[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    String unescapeString(String st) {
        StringBuilder sb = new StringBuilder(st.length());
        int i = 0;
        while (true) {
            block13: {
                int ch;
                block12: {
                    if (i >= st.length()) {
                        return sb.toString();
                    }
                    ch = st.charAt(i);
                    if (ch != 92) break block12;
                    int nextChar = i == st.length() - 1 ? 92 : (int)st.charAt(i + 1);
                    switch (nextChar) {
                        case 92: {
                            ch = 92;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 117: {
                            if (i >= st.length() - 5) {
                                ch = 117;
                                break;
                            }
                            int code = Integer.parseInt("" + st.charAt(i + 2) + st.charAt(i + 3) + st.charAt(i + 4) + st.charAt(i + 5), 16);
                            sb.append(Character.toChars(code));
                            i += 5;
                            break block13;
                        }
                    }
                    ++i;
                }
                sb.append((char)ch);
            }
            ++i;
        }
    }
}

