/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Dispatcher;
import io.nats.client.Message;
import io.nats.client.Subscription;
import io.nats.client.impl.MessageQueue;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsConsumer;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsMessage;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;

class NatsSubscription
extends NatsConsumer
implements Subscription {
    private String subject;
    private String queueName;
    private String sid;
    private NatsConnection connection;
    private NatsDispatcher dispatcher;
    private MessageQueue incoming;
    private AtomicLong unSubMessageLimit;

    NatsSubscription(String sid, String subject, String queueName, NatsConnection connection, NatsDispatcher dispatcher) {
        this.subject = subject;
        this.queueName = queueName;
        this.sid = sid;
        this.dispatcher = dispatcher;
        this.connection = connection;
        this.unSubMessageLimit = new AtomicLong(-1L);
        if (this.dispatcher == null) {
            this.incoming = new MessageQueue(false);
        }
    }

    @Override
    public boolean isActive() {
        return this.dispatcher != null || this.incoming != null;
    }

    void invalidate() {
        if (this.incoming != null) {
            this.incoming.pause();
        }
        this.dispatcher = null;
        this.incoming = null;
    }

    void setUnsubLimit(long cd) {
        this.unSubMessageLimit.set(cd);
    }

    boolean reachedUnsubLimit() {
        long max = this.unSubMessageLimit.get();
        long recv = this.getDeliveredCount();
        return max > 0L && max <= recv;
    }

    String getSID() {
        return this.sid;
    }

    NatsDispatcher getNatsDispatcher() {
        return this.dispatcher;
    }

    @Override
    MessageQueue getMessageQueue() {
        return this.incoming;
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public Message nextMessage(Duration timeout) throws InterruptedException, IllegalStateException {
        if (this.dispatcher != null) {
            throw new IllegalStateException("Subscriptions that belong to a dispatcher cannot respond to nextMessage directly.");
        }
        if (this.incoming == null) {
            throw new IllegalStateException("This subscription is inactive.");
        }
        NatsMessage msg = this.incoming.pop(timeout);
        if (this.incoming == null || !this.incoming.isRunning()) {
            throw new IllegalStateException("This subscription is inactive.");
        }
        this.incrementDeliveredCount();
        if (this.reachedUnsubLimit()) {
            this.connection.invalidate(this);
        }
        return msg;
    }

    @Override
    public void unsubscribe() {
        if (this.dispatcher != null) {
            throw new IllegalStateException("Subscriptions that belong to a dispatcher cannot respond to unsubscribe directly.");
        }
        if (this.incoming == null) {
            throw new IllegalStateException("This subscription is inactive.");
        }
        this.connection.unsubscribe(this, -1);
    }

    @Override
    public Subscription unsubscribe(int after) {
        if (this.dispatcher != null) {
            throw new IllegalStateException("Subscriptions that belong to a dispatcher cannot respond to unsubscribe directly.");
        }
        if (this.incoming == null) {
            throw new IllegalStateException("This subscription is inactive.");
        }
        this.connection.unsubscribe(this, after);
        return this;
    }
}

