/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.impl.DataPort;
import io.nats.client.impl.MessageQueue;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.NatsStatistics;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

class NatsConnectionWriter
implements Runnable {
    private final NatsConnection connection;
    private Thread thread;
    private CompletableFuture<Boolean> stopped;
    private Future<DataPort> dataPortFuture;
    private final AtomicBoolean running;
    private byte[] sendBuffer;
    private MessageQueue outgoing;

    NatsConnectionWriter(NatsConnection connection) {
        this.connection = connection;
        this.running = new AtomicBoolean(false);
        this.stopped = new CompletableFuture();
        this.stopped.complete(Boolean.TRUE);
        this.sendBuffer = new byte[connection.getOptions().getBufferSize()];
        this.outgoing = new MessageQueue(true);
    }

    void start(Future<DataPort> dataPortFuture) {
        this.dataPortFuture = dataPortFuture;
        this.running.set(true);
        this.stopped = new CompletableFuture();
        String name = this.connection.getOptions().getConnectionName() != null ? this.connection.getOptions().getConnectionName() : "Nats Connection";
        this.thread = new Thread((Runnable)this, name + " Writer");
        this.thread.start();
    }

    Future<Boolean> stop() {
        this.running.set(false);
        this.outgoing.pause();
        byte[] pingRequest = "PING".getBytes(StandardCharsets.UTF_8);
        byte[] pongRequest = "PONG".getBytes(StandardCharsets.UTF_8);
        this.outgoing.filter(msg -> Arrays.equals(pingRequest, msg.getProtocolBytes()) || Arrays.equals(pongRequest, msg.getProtocolBytes()));
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Duration waitForMessage = Duration.ofMinutes(2L);
        long maxMessages = 1000L;
        try {
            DataPort dataPort = this.dataPortFuture.get();
            NatsStatistics stats = this.connection.getNatsStatistics();
            this.outgoing.resume();
            while (this.running.get()) {
                int sendPosition = 0;
                NatsMessage msg = this.outgoing.accumulate(this.sendBuffer.length, maxMessages, waitForMessage);
                if (msg == null) continue;
                while (msg != null) {
                    long size = msg.getSizeInBytes();
                    if ((long)sendPosition + size > (long)this.sendBuffer.length) {
                        if (sendPosition == 0) {
                            this.sendBuffer = new byte[(int)Math.max((long)this.sendBuffer.length + size, (long)(this.sendBuffer.length * 2))];
                        } else {
                            dataPort.write(this.sendBuffer, sendPosition);
                            this.connection.getNatsStatistics().registerWrite(sendPosition);
                            sendPosition = 0;
                            msg = msg.next;
                            if (msg == null) break;
                        }
                    }
                    byte[] bytes = msg.getProtocolBytes();
                    System.arraycopy(bytes, 0, this.sendBuffer, sendPosition, bytes.length);
                    sendPosition += bytes.length;
                    this.sendBuffer[sendPosition++] = 13;
                    this.sendBuffer[sendPosition++] = 10;
                    if (!msg.isProtocol()) {
                        bytes = msg.getData();
                        System.arraycopy(bytes, 0, this.sendBuffer, sendPosition, bytes.length);
                        sendPosition += bytes.length;
                        this.sendBuffer[sendPosition++] = 13;
                        this.sendBuffer[sendPosition++] = 10;
                    }
                    stats.incrementOutMsgs();
                    stats.incrementOutBytes(size);
                    msg = msg.next;
                }
                dataPort.write(this.sendBuffer, sendPosition);
                this.connection.getNatsStatistics().registerWrite(sendPosition);
            }
        }
        catch (IOException | BufferOverflowException io) {
            this.connection.handleCommunicationIssue(io);
        }
        catch (InterruptedException | CancellationException | ExecutionException exception) {
        }
        finally {
            this.running.set(false);
            this.stopped.complete(Boolean.TRUE);
            this.thread = null;
        }
    }

    boolean canQueue(NatsMessage msg, long maxSize) {
        return maxSize <= 0L || this.outgoing.sizeInBytes() + msg.getSizeInBytes() < maxSize;
    }

    void queue(NatsMessage msg) {
        this.outgoing.push(msg);
    }
}

