/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Consumer;
import io.nats.client.impl.MessageQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

abstract class NatsConsumer
implements Consumer {
    private AtomicLong maxMessages = new AtomicLong();
    private AtomicLong maxBytes = new AtomicLong();
    private AtomicLong droppedMessages = new AtomicLong();
    private AtomicLong messagesDelivered = new AtomicLong(0L);
    private AtomicBoolean slow = new AtomicBoolean(false);

    NatsConsumer() {
    }

    @Override
    public void setPendingLimits(long maxMessages, long maxBytes) {
        this.maxMessages.set(maxMessages);
        this.maxBytes.set(maxBytes);
    }

    @Override
    public long getPendingMessageLimit() {
        return this.maxMessages.get();
    }

    @Override
    public long getPendingByteLimit() {
        return this.maxBytes.get();
    }

    @Override
    public long getPendingMessageCount() {
        return this.getMessageQueue().length();
    }

    @Override
    public long getPendingByteCount() {
        return this.getMessageQueue().sizeInBytes();
    }

    @Override
    public long getDeliveredCount() {
        return this.messagesDelivered.get();
    }

    void incrementDeliveredCount() {
        this.messagesDelivered.incrementAndGet();
    }

    void incrementDroppedCount() {
        this.droppedMessages.incrementAndGet();
    }

    @Override
    public long getDroppedCount() {
        return this.droppedMessages.get();
    }

    @Override
    public void clearDroppedCount() {
        this.droppedMessages.set(0L);
    }

    void markSlow() {
        this.slow.set(true);
    }

    void markNotSlow() {
        this.slow.set(false);
    }

    boolean isMarkedSlow() {
        return this.slow.get();
    }

    boolean hasReachedPendingLimits() {
        return this.getPendingByteCount() >= this.getPendingByteLimit() && this.getPendingByteLimit() > 0L || this.getPendingMessageCount() >= this.getPendingMessageLimit() && this.getPendingMessageLimit() > 0L;
    }

    @Override
    public abstract boolean isActive();

    abstract MessageQueue getMessageQueue();
}

