# Java Nats Examples

This folder contains a number of examples:

### Regular Nats Examples
1. `ConnectTime.java` - how to build a listener that will track connect time.
1. `NatsPub.java` - publishes messages
1. `NatsPubMany.java` - publishes many messages
1. `NatsReply.java` - sends a reply when a request is received
1. `NatsReq.java` - sends a request and prints the reply
1. `NatsReqFuture.java` - sends a request async using a future 
1. `NatsSub.java` - reads messages synchronously
1. `NatsSubDispatch.java` - uses asynchronous dispatching for incoming messages
1. `NatsSubQueue.java` - subscribes on a queue for message load balancing
1. `NatsSubQueueFull.java` - fuller publish and queue subscribe example
   
### JetStream Examples
In the `io.nats.examples.jetstream` package...

1. `NatsJsPub.java` - publish JetStream messages
1. `NatsJsPubAsync.java` - publish JetStream messages asynchronously
1. `NatsJsPubVsRegularPub.java` - publish JetStream messages versus regular publish to the same stream.
1. `NatsJsPubWithOptionsUseCases` - publish JetStream with examples on using publish options
1. `NatsJsPullSubBatchSize.java` - pull subscription example specifying batch size and manual handling
1. `NatsJsPullSubBatchSizeUseCases.java` - pull subscription example specifying batch size with examples of manual handling various cases of available messages  
1. `NatsJsPullSubExpire.java` - pull subscription example specifying expiration and manual handling
1. `NatsJsPullSubExpireUseCases.java` - pull subscription example specifying expiration with examples of manual handling various cases of available messages
1. `NatsJsPullSubFetch.java` - pull subscription example using fetch list macro function
1. `NatsJsPullSubFetchUseCases.java` - pull subscription example using fetch list macro function with examples of various cases of available messages
1. `NatsJsPullSubIterate.java` - pull subscription example using iterate macro function
1. `NatsJsPullSubIterateUseCases.java` - pull subscription example using iterate macro function with examples of various cases of available messages
1. `NatsJsPullSubMultiple.java` - multiple pull subscriptions using the same durable consumer work like a sharing queue
1. `NatsJsPullSubNoWaitUseCases.java` - pull subscription example specifying no wait with examples of manual handling various cases of available messages
1. `NatsJsPushSub.java` - push subscribing to read messages synchronously and manually acknowledges messages.
1. `NatsJsPushSubDeliverSubject.java` - push subscribing with a deliver subject and how the subject can be read as a regular Nats Message  
1. `NatsJsPushSubQueue.java` - push subscribing to read messages in a load balance queue.
1. `NatsJsPushSubWithHandler.java` - push subscribing to read messages asynchronously and manually acknowledge messages.

### JetStream Management / Admin Examples
1. `NatsJsManageConsumers.java` - demonstrate the management of consumers
1. `NatsJsManageStreams.java` - demonstrate the management of streams

### Other examples
1. `autobench` - benchmarks the current system/setup in several scenarios
1. `benchmark` - benchmark that supports multiple threads
1. `stan` - A larger example that implements a server that can respond on multiple subjects, and several clients that send requests on those various subjects.
1. `stability` - a small producer and subscriber that run forever printing some status every so often. These are intended for long running tests without burning the CPU.

### Example Support
1. `ExampleArgs.java` - Helper to manage command line arguments.
1. `ExampleAuthHandler.java` - Example of an auth handler.
1. `ExampleUtils.java` - Miscellaneous utils used to start or in running examples.
1. `NatsJsUtils.java` - Miscellaneous utils specific to JetStream examples.

All of these examples take the server URL on the command line, which means that you can use the `tls` and `opentls` schemas to test over a secure connection.

## Running the examples

The examples require the client library and the examples to be compiled. See the [readme.md](/README.md) for specifics on building these.

```bash
java -cp build/libs/jnats-2.10.0.jar:build/libs/jnats-2.10.0-examples.jar io.nats.examples.NatsPub nats://localhost:4222 test "hello world"
```

To see how queues split messages, run the `NatsQSub` in multiple windows and then run `NatsPub`. Messages should be distributed between the clients. On the other hand, if you run `NatsSub` in multiple shells and then run `NatsPub` you will get the message at all subscribers.

## Running with TLS

A set of sample certificates are provided in the repo for testing. These use the highly secure password `password`. To run with the full client and trust default keystore you can use command line arguments to set System properties.

```bash
java -Djavax.net.ssl.keyStore=src/test/resources/keystore.jks -Djavax.net.ssl.keyStorePassword=password -Djavax.net.ssl.trustStore=src/test/resources/truststore.jks -Djavax.net.ssl.trustStorePassword=password io.nats.examples.NatsPub tls://localhost:4443 test "hello world"
```

To run with the completely unverified client:

```bash
java -cp build/libs/jnats-2.10.0.jar:build/libs/jnats-2.10.0-examples.jar io.nats.examples.NatsSub opentls://localhost:4443 test 3
```

There are a set tls configuration for the server in the test files that can be used to run the NATS server.

```bash
nats-server --conf src/test/resources/tls.conf
```

As well as one with the verify flag set.

```bash
nats-server --conf src/test/resources/tlsverify.conf
```

which will require client certificates.
