/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.SubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.support.Validator;

public class PushSubscribeOptions
extends SubscribeOptions {
    private PushSubscribeOptions(String stream, ConsumerConfiguration consumerConfig) {
        super(stream, consumerConfig);
    }

    public String getDeliverSubject() {
        return this.consumerConfig.getDeliverSubject();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends SubscribeOptions.Builder<Builder, PushSubscribeOptions> {
        private String deliverSubject;

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder deliverSubject(String deliverSubject) {
            this.deliverSubject = deliverSubject;
            return this;
        }

        @Override
        public PushSubscribeOptions build() {
            Validator.validateStreamNameOrEmptyAsNull(this.stream);
            this.durable = Validator.validateDurableOrEmptyAsNull(this.durable);
            if (this.durable == null && this.consumerConfig != null) {
                this.durable = Validator.validateDurableOrEmptyAsNull(this.consumerConfig.getDurable());
            }
            this.consumerConfig = ConsumerConfiguration.builder(this.consumerConfig).durable(this.durable).deliverSubject(Validator.emptyAsNull(this.deliverSubject)).build();
            return new PushSubscribeOptions(this.stream, this.consumerConfig);
        }
    }
}

