/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.support.ByteArrayBuilder;
import io.nats.client.support.NatsConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

public class Headers {
    private static final String KEY_CANNOT_BE_EMPTY_OR_NULL = "Header key cannot be null.";
    private static final String KEY_INVALID_CHARACTER = "Header key has invalid character: ";
    private static final String VALUE_INVALID_CHARACTERS = "Header value has invalid character: ";
    private final Map<String, List<String>> headerMap = new HashMap<String, List<String>>();
    private byte[] serialized;
    private int projectedLength;

    public Headers() {
    }

    public Headers(Headers headers) {
        this();
        if (headers != null) {
            this.headerMap.putAll(headers.headerMap);
            this.projectedLength = headers.projectedLength;
            this.serialized = null;
        }
    }

    public Headers add(String key, String ... values) {
        if (values != null) {
            this._add(key, Arrays.asList(values));
        }
        return this;
    }

    public Headers add(String key, Collection<String> values) {
        this._add(key, values);
        return this;
    }

    private void _add(String key, Collection<String> values) {
        Checker checked;
        if (values != null && (checked = new Checker(key, values)).hasValues()) {
            List<String> currentSet = this.headerMap.get(key);
            if (currentSet == null) {
                this.headerMap.put(key, checked.list);
            } else {
                currentSet.addAll(checked.list);
            }
            this.serialized = null;
            this.projectedLength += key.length() + checked.length;
        }
    }

    public Headers put(String key, String ... values) {
        if (values != null) {
            this._put(key, Arrays.asList(values));
        }
        return this;
    }

    public Headers put(String key, Collection<String> values) {
        this._put(key, values);
        return this;
    }

    private void _put(String key, Collection<String> values) {
        Checker checked;
        if (values != null && (checked = new Checker(key, values)).hasValues()) {
            this.headerMap.put(key, checked.list);
            this.serialized = null;
            this.projectedLength += key.length() + checked.length;
        }
    }

    public void remove(String ... keys) {
        for (String key : keys) {
            this.headerMap.remove(key);
            this.projectedLength -= key.length() + 1;
        }
        this.serialized = null;
    }

    public void remove(Collection<String> keys) {
        for (String key : keys) {
            this.headerMap.remove(key);
            this.projectedLength -= key.length() + 1;
        }
        this.serialized = null;
    }

    public int size() {
        return this.headerMap.size();
    }

    public boolean isEmpty() {
        return this.headerMap.isEmpty();
    }

    public void clear() {
        this.headerMap.clear();
        this.serialized = null;
        this.projectedLength = 0;
    }

    public boolean containsKey(String key) {
        return this.headerMap.containsKey(key);
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.headerMap.keySet());
    }

    public List<String> get(String key) {
        List<String> values = this.headerMap.get(key);
        return values == null ? null : new ArrayList<String>(values);
    }

    public void forEach(BiConsumer<String, List<String>> action) {
        Collections.unmodifiableMap(this.headerMap).forEach(action);
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return Collections.unmodifiableSet(this.headerMap.entrySet());
    }

    public boolean isDirty() {
        return this.serialized == null;
    }

    public int serializedLength() {
        return this.getSerialized().length;
    }

    public byte[] getSerialized() {
        if (this.serialized == null) {
            ByteArrayBuilder bab = new ByteArrayBuilder(this.projectedLength + NatsConstants.VERSION_BYTES_PLUS_CRLF_LEN).append(NatsConstants.VERSION_BYTES_PLUS_CRLF);
            for (String key : this.headerMap.keySet()) {
                for (String value : this.headerMap.get(key)) {
                    bab.append(key);
                    bab.append(NatsConstants.COLON_BYTES);
                    bab.append(value);
                    bab.append(NatsConstants.CRLF_BYTES);
                }
            }
            bab.append(NatsConstants.CRLF_BYTES);
            this.serialized = bab.toByteArray();
        }
        return this.serialized;
    }

    private void checkKey(String key) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException(KEY_CANNOT_BE_EMPTY_OR_NULL);
        }
        int len = key.length();
        for (int idx = 0; idx < len; ++idx) {
            char c = key.charAt(idx);
            if (c >= '!' && c <= '~' && c != ':') continue;
            throw new IllegalArgumentException("Header key has invalid character: '" + c + "'");
        }
    }

    private void checkValue(String val) {
        val.chars().forEach((int c) -> {
            if (c < 32 && c != 9 || c > 126) {
                throw new IllegalArgumentException(VALUE_INVALID_CHARACTERS + c);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Headers headers = (Headers)o;
        return Objects.equals(this.headerMap, headers.headerMap);
    }

    public int hashCode() {
        return Objects.hash(this.headerMap);
    }

    private class Checker {
        List<String> list = new ArrayList<String>();
        int length;

        Checker(String key, Collection<String> values) {
            Headers.this.checkKey(key);
            this.length += key.length() + 1;
            if (!values.isEmpty()) {
                for (String val : values) {
                    if (val == null) continue;
                    if (val.isEmpty()) {
                        this.list.add(val);
                        continue;
                    }
                    Headers.this.checkValue(val);
                    this.list.add(val);
                    this.length += val.length();
                }
            }
        }

        boolean hasValues() {
            return this.list.size() > 0;
        }
    }
}

