/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.api.ConsumerConfiguration;
import java.time.Duration;

public abstract class Validator {
    private Validator() {
    }

    public static String validateMessageSubjectRequired(String s) {
        if (Validator.nullOrEmpty(s)) {
            throw new IllegalArgumentException("Subject cannot be null or empty [" + s + "]");
        }
        return s;
    }

    public static String validateJsSubscribeSubjectRequired(String s) {
        if (Validator.nullOrEmpty(s) || Validator.containsWhitespace(s)) {
            throw new IllegalArgumentException("Subject cannot have whitespace if provided [" + s + "]");
        }
        return s;
    }

    public static String validateQueueNameRequired(String s) {
        if (Validator.nullOrEmpty(s) || Validator.containsWhitespace(s)) {
            throw new IllegalArgumentException("Queue have whitespace [" + s + "]");
        }
        return Validator.emptyAsNull(s);
    }

    public static String validateReplyToNullButNotEmpty(String s) {
        if (Validator.notNullButEmpty(s)) {
            throw new IllegalArgumentException("ReplyTo cannot be blank when provided [" + s + "]");
        }
        return s;
    }

    public static String validateStreamName(String s) {
        if (Validator.containsDotWildGt(s)) {
            throw new IllegalArgumentException("Stream cannot contain a '.', '*' or '>' [" + s + "]");
        }
        return s;
    }

    public static String validateStreamNameOrEmptyAsNull(String s) {
        return Validator.emptyAsNull(Validator.validateStreamName(s));
    }

    public static String validateStreamNameRequired(String s) {
        if (Validator.nullOrEmpty(s)) {
            throw new IllegalArgumentException("Stream cannot be null or empty and cannot contain a '.', '*' or '>' [" + s + "]");
        }
        return Validator.validateStreamName(s);
    }

    public static String validateDurableOrEmptyAsNull(String s) {
        if (Validator.containsDotWildGt(s)) {
            throw new IllegalArgumentException("Durable cannot contain a '.', '*' or '>' [" + s + "]");
        }
        return Validator.emptyAsNull(s);
    }

    public static String validateDurableRequired(String durable, ConsumerConfiguration cc) {
        if (durable == null) {
            if (cc == null) {
                throw new IllegalArgumentException("Durable is required and cannot contain a '.', '*' or '>' [null]");
            }
            return Validator.validateDurableRequired(cc.getDurable());
        }
        return Validator.validateDurableRequired(durable);
    }

    public static String validateDurableRequired(String s) {
        if (Validator.nullOrEmpty(s) || Validator.containsDotWildGt(s)) {
            throw new IllegalArgumentException("Durable is required and cannot contain a '.', '*' or '>' [" + s + "]");
        }
        return s;
    }

    public static int validatePullBatchSize(int pullBatchSize) {
        if (pullBatchSize < 1 || pullBatchSize > 256) {
            throw new IllegalArgumentException("Pull Batch Size must be between 1 and 256 inclusive [" + pullBatchSize + "]");
        }
        return pullBatchSize;
    }

    public static long validateMaxConsumers(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Consumers");
    }

    public static long validateMaxMessages(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Messages");
    }

    public static long validateMaxBytes(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Bytes");
    }

    public static long validateMaxMessageSize(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max message size");
    }

    public static int validateNumberOfReplicas(int replicas) {
        if (replicas < 1 || replicas > 5) {
            throw new IllegalArgumentException("Replicas must be from 1 to 5 inclusive.");
        }
        return replicas;
    }

    public static Duration validateDurationRequired(Duration d) {
        if (d == null || d.isZero() || d.isNegative()) {
            throw new IllegalArgumentException("Duration required and must be greater than 0.");
        }
        return d;
    }

    public static Duration validateDurationNotRequiredGtOrEqZero(Duration d) {
        if (d == null) {
            return Duration.ZERO;
        }
        if (d.isNegative()) {
            throw new IllegalArgumentException("Duration must be greater than or equal to 0.");
        }
        return d;
    }

    public static String validateJetStreamPrefix(String s) {
        if (Validator.containsWildGtDollarSpaceTab(s)) {
            throw new IllegalArgumentException("Prefix cannot contain a wildcard or dollar sign [" + s + "]");
        }
        return s;
    }

    public static Object validateNotNull(Object o, String fieldName) {
        if (o == null) {
            throw new IllegalArgumentException(fieldName + " cannot be null");
        }
        return o;
    }

    public static String validateNotNull(String s, String fieldName) {
        if (s == null) {
            throw new IllegalArgumentException(fieldName + " cannot be null");
        }
        return s;
    }

    public static long validateGtZeroOrMinus1(long l, String label) {
        if (Validator.zeroOrLtMinus1(l)) {
            throw new IllegalArgumentException(label + " must be greater than zero or -1 for unlimited");
        }
        return l;
    }

    public static boolean nullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean notNullButEmpty(String s) {
        return s != null && s.length() == 0;
    }

    public static boolean containsWhitespace(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (!Character.isWhitespace(s.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsDotWildGt(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                switch (s.charAt(i)) {
                    case '*': 
                    case '.': 
                    case '>': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean containsWildGtDollarSpaceTab(String s) {
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                switch (s.charAt(i)) {
                    case '\t': 
                    case ' ': 
                    case '$': 
                    case '*': 
                    case '>': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String emptyAsNull(String s) {
        return Validator.nullOrEmpty(s) ? null : s;
    }

    public static boolean zeroOrLtMinus1(long l) {
        return l == 0L || l < -1L;
    }
}

