/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Statistics;
import java.text.NumberFormat;
import java.util.LongSummaryStatistics;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

class NatsStatistics
implements Statistics {
    private ReentrantLock lock;
    private LongSummaryStatistics readStats;
    private LongSummaryStatistics writeStats;
    private AtomicLong flushCounter;
    private AtomicLong outstandingRequests;
    private AtomicLong requestsSent;
    private AtomicLong repliesReceived;
    private AtomicLong duplicateRepliesReceived;
    private AtomicLong orphanRepliesReceived;
    private AtomicLong reconnects;
    private AtomicLong inMsgs;
    private AtomicLong outMsgs;
    private AtomicLong inBytes;
    private AtomicLong outBytes;
    private AtomicLong pingCount;
    private AtomicLong okCount;
    private AtomicLong errCount;
    private AtomicLong exceptionCount;
    private AtomicLong droppedCount;
    private final boolean trackAdvanced;

    public NatsStatistics(boolean trackAdvanced) {
        this.trackAdvanced = trackAdvanced;
        this.readStats = new LongSummaryStatistics();
        this.writeStats = new LongSummaryStatistics();
        this.lock = new ReentrantLock();
        this.flushCounter = new AtomicLong();
        this.outstandingRequests = new AtomicLong();
        this.requestsSent = new AtomicLong();
        this.repliesReceived = new AtomicLong();
        this.duplicateRepliesReceived = new AtomicLong();
        this.orphanRepliesReceived = new AtomicLong();
        this.reconnects = new AtomicLong();
        this.inMsgs = new AtomicLong();
        this.outMsgs = new AtomicLong();
        this.inBytes = new AtomicLong();
        this.outBytes = new AtomicLong();
        this.pingCount = new AtomicLong();
        this.okCount = new AtomicLong();
        this.errCount = new AtomicLong();
        this.exceptionCount = new AtomicLong();
        this.droppedCount = new AtomicLong();
    }

    void incrementPingCount() {
        this.pingCount.incrementAndGet();
    }

    void incrementDroppedCount() {
        this.droppedCount.incrementAndGet();
    }

    void incrementOkCount() {
        this.okCount.incrementAndGet();
    }

    void incrementErrCount() {
        this.errCount.incrementAndGet();
    }

    void incrementExceptionCount() {
        this.exceptionCount.incrementAndGet();
    }

    void incrementRequestsSent() {
        this.requestsSent.incrementAndGet();
    }

    void incrementRepliesReceived() {
        this.repliesReceived.incrementAndGet();
    }

    void incrementDuplicateRepliesReceived() {
        this.duplicateRepliesReceived.incrementAndGet();
    }

    void incrementOrphanRepliesReceived() {
        this.orphanRepliesReceived.incrementAndGet();
    }

    void incrementReconnects() {
        this.reconnects.incrementAndGet();
    }

    void incrementInMsgs() {
        this.inMsgs.incrementAndGet();
    }

    void incrementOutMsgs() {
        this.outMsgs.incrementAndGet();
    }

    void incrementInBytes(long bytes) {
        this.inBytes.addAndGet(bytes);
    }

    void incrementOutBytes(long bytes) {
        this.outBytes.addAndGet(bytes);
    }

    void incrementFlushCounter() {
        this.flushCounter.incrementAndGet();
    }

    void incrementOutstandingRequests() {
        this.outstandingRequests.incrementAndGet();
    }

    void decrementOutstandingRequests() {
        this.outstandingRequests.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSummaryStat(LongSummaryStatistics stats, long value) {
        if (!this.trackAdvanced) {
            return;
        }
        this.lock.lock();
        try {
            stats.accept(value);
        }
        finally {
            this.lock.unlock();
        }
    }

    void registerRead(long bytes) {
        this.registerSummaryStat(this.readStats, bytes);
    }

    void registerWrite(long bytes) {
        this.registerSummaryStat(this.writeStats, bytes);
    }

    public long getPings() {
        return this.pingCount.get();
    }

    @Override
    public long getDroppedCount() {
        return this.droppedCount.get();
    }

    public long getOKs() {
        return this.okCount.get();
    }

    public long getErrs() {
        return this.errCount.get();
    }

    public long getExceptions() {
        return this.exceptionCount.get();
    }

    @Override
    public long getReconnects() {
        return this.reconnects.get();
    }

    @Override
    public long getInMsgs() {
        return this.inMsgs.get();
    }

    @Override
    public long getOutMsgs() {
        return this.outMsgs.get();
    }

    @Override
    public long getInBytes() {
        return this.inBytes.get();
    }

    @Override
    public long getOutBytes() {
        return this.outBytes.get();
    }

    long getFlushCounter() {
        return this.flushCounter.get();
    }

    long getOutstandingRequests() {
        return this.outstandingRequests.get();
    }

    public long getRepliesReceived() {
        return this.repliesReceived.get();
    }

    public long getDuplicateRepliesReceived() {
        return this.duplicateRepliesReceived.get();
    }

    public long getOrphanRepliesReceived() {
        return this.orphanRepliesReceived.get();
    }

    void appendNumberStat(StringBuilder builder, String name, long value) {
        builder.append(name);
        builder.append(NumberFormat.getNumberInstance().format(value));
        builder.append("\n");
    }

    void appendNumberStat(StringBuilder builder, String name, double value) {
        builder.append(name);
        builder.append(NumberFormat.getNumberInstance().format(value));
        builder.append("\n");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.lock.lock();
        try {
            builder.append("### Connection ###\n");
            this.appendNumberStat(builder, "Reconnects:                      ", this.reconnects.get());
            if (this.trackAdvanced) {
                this.appendNumberStat(builder, "Requests Sent:                   ", this.requestsSent.get());
                this.appendNumberStat(builder, "Replies Received:                ", this.repliesReceived.get());
                this.appendNumberStat(builder, "Duplicate Replies Received:      ", this.duplicateRepliesReceived.get());
                this.appendNumberStat(builder, "Orphan Replies Received:         ", this.orphanRepliesReceived.get());
                this.appendNumberStat(builder, "Pings Sent:                      ", this.pingCount.get());
                this.appendNumberStat(builder, "+OKs Received:                   ", this.okCount.get());
                this.appendNumberStat(builder, "-Errs Received:                  ", this.errCount.get());
                this.appendNumberStat(builder, "Handled Exceptions:              ", this.exceptionCount.get());
                this.appendNumberStat(builder, "Successful Flush Calls:          ", this.flushCounter.get());
                this.appendNumberStat(builder, "Outstanding Request Futures:     ", this.outstandingRequests.get());
                this.appendNumberStat(builder, "Dropped Messages:                ", this.droppedCount.get());
            }
            builder.append("\n");
            builder.append("### Reader ###\n");
            this.appendNumberStat(builder, "Messages in:                     ", this.inMsgs.get());
            this.appendNumberStat(builder, "Bytes in:                        ", this.inBytes.get());
            builder.append("\n");
            if (this.trackAdvanced) {
                this.appendNumberStat(builder, "Socket Reads:                    ", this.readStats.getCount());
                this.appendNumberStat(builder, "Average Bytes Per Read:          ", this.readStats.getAverage());
                this.appendNumberStat(builder, "Min Bytes Per Read:              ", this.readStats.getMin());
                this.appendNumberStat(builder, "Max Bytes Per Read:              ", this.readStats.getMax());
            }
            builder.append("\n");
            builder.append("### Writer ###\n");
            this.appendNumberStat(builder, "Messages out:                    ", this.outMsgs.get());
            this.appendNumberStat(builder, "Bytes out:                       ", this.outBytes.get());
            builder.append("\n");
            if (this.trackAdvanced) {
                this.appendNumberStat(builder, "Socket Writes:                   ", this.writeStats.getCount());
                this.appendNumberStat(builder, "Average Bytes Per Write:         ", this.writeStats.getAverage());
                this.appendNumberStat(builder, "Min Bytes Per Write:             ", this.writeStats.getMin());
                this.appendNumberStat(builder, "Max Bytes Per Write:             ", this.writeStats.getMax());
            }
        }
        finally {
            this.lock.unlock();
        }
        return builder.toString();
    }
}

