/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.api.ConsumerConfiguration;
import java.time.Duration;

public abstract class Validator {
    static final char[] WILD_GT = new char[]{'*', '>'};
    static final char[] WILD_GT_DOT = new char[]{'*', '>', '.'};
    static final char[] WILD_GT_DOLLAR = new char[]{'*', '>', '$'};

    private Validator() {
    }

    public static String validateSubject(String s, boolean required) {
        return Validator.validatePrintable(s, "Subject", required);
    }

    public static String validateReplyTo(String s, boolean required) {
        return Validator.validatePrintableExceptWildGt(s, "Reply To", required);
    }

    public static String validateQueueName(String s, boolean required) {
        return Validator.validatePrintableExceptWildDotGt(s, "Queue", required);
    }

    public static String validateStreamName(String s, boolean required) {
        return Validator.validatePrintableExceptWildDotGt(s, "Stream", required);
    }

    public static String validateDurable(String s, boolean required) {
        return Validator.validatePrintableExceptWildDotGt(s, "Durable", required);
    }

    public static String validateDurableRequired(String durable, ConsumerConfiguration cc) {
        if (durable == null) {
            if (cc == null) {
                throw new IllegalArgumentException("Durable is required.");
            }
            return Validator.validateDurable(cc.getDurable(), true);
        }
        return Validator.validateDurable(durable, true);
    }

    public static String validateJetStreamPrefix(String s) {
        return Validator.validatePrintableExceptWildGtDollar(s, "Prefix", false);
    }

    public static String _validate(String s, String label, boolean required, Check check) {
        if (required) {
            if (Validator.nullOrEmpty(s)) {
                throw new IllegalArgumentException(label + " cannot be null or empty [" + s + "]");
            }
        } else if (Validator.emptyAsNull(s) == null) {
            return null;
        }
        return check.check(s, label);
    }

    public static String validatePrintable(String s, String label, boolean required) {
        return Validator._validate(s, label, required, (ss, ll) -> {
            if (Validator.notPrintable(s)) {
                throw new IllegalArgumentException(label + " must be in the printable ASCII range [" + s + "]");
            }
            return s;
        });
    }

    public static String validatePrintableExceptWildDotGt(String s, String label, boolean required) {
        return Validator._validate(s, label, required, (ss, ll) -> {
            if (Validator.notPrintableOrHasWildGtDot(s)) {
                throw new IllegalArgumentException(label + " must be in the printable ASCII range and cannot include `*`, `.` or `>` [" + s + "]");
            }
            return s;
        });
    }

    public static String validatePrintableExceptWildGt(String s, String label, boolean required) {
        return Validator._validate(s, label, required, (ss, ll) -> {
            if (Validator.notPrintableOrHasWildGt(s)) {
                throw new IllegalArgumentException(label + " must be in the printable ASCII range and cannot include `*`, `>` or `$` [" + s + "]");
            }
            return s;
        });
    }

    public static String validatePrintableExceptWildGtDollar(String s, String label, boolean required) {
        return Validator._validate(s, label, required, (ss, ll) -> {
            if (Validator.notPrintableOrHasWildGtDollar(s)) {
                throw new IllegalArgumentException(label + " must be in the printable ASCII range and cannot include `*`, `>` or `$` [" + s + "]");
            }
            return s;
        });
    }

    public static int validatePullBatchSize(int pullBatchSize) {
        if (pullBatchSize < 1 || pullBatchSize > 256) {
            throw new IllegalArgumentException("Pull Batch Size must be between 1 and 256 inclusive [" + pullBatchSize + "]");
        }
        return pullBatchSize;
    }

    public static long validateMaxConsumers(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Consumers");
    }

    public static long validateMaxMessages(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Messages");
    }

    public static long validateMaxBytes(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max Bytes");
    }

    public static long validateMaxMessageSize(long max) {
        return Validator.validateGtZeroOrMinus1(max, "Max message size");
    }

    public static int validateNumberOfReplicas(int replicas) {
        if (replicas < 1 || replicas > 5) {
            throw new IllegalArgumentException("Replicas must be from 1 to 5 inclusive.");
        }
        return replicas;
    }

    public static Duration validateDurationRequired(Duration d) {
        if (d == null || d.isZero() || d.isNegative()) {
            throw new IllegalArgumentException("Duration required and must be greater than 0.");
        }
        return d;
    }

    public static Duration validateDurationNotRequiredGtOrEqZero(Duration d) {
        if (d == null) {
            return Duration.ZERO;
        }
        if (d.isNegative()) {
            throw new IllegalArgumentException("Duration must be greater than or equal to 0.");
        }
        return d;
    }

    public static void validateNotNull(Object o, String fieldName) {
        if (o == null) {
            throw new IllegalArgumentException(fieldName + " cannot be null");
        }
    }

    public static long validateGtZeroOrMinus1(long l, String label) {
        if (Validator.zeroOrLtMinus1(l)) {
            throw new IllegalArgumentException(label + " must be greater than zero or -1 for unlimited");
        }
        return l;
    }

    public static long validateNotNegative(long l, String label) {
        if (l < 0L) {
            throw new IllegalArgumentException(label + " cannot be negative");
        }
        return l;
    }

    public static boolean nullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean notPrintable(String s) {
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c >= '!' && c <= '~') continue;
            return true;
        }
        return false;
    }

    public static boolean notPrintableOrHasChars(String s, char[] charsToNotHave) {
        for (int x = 0; x < s.length(); ++x) {
            char c = s.charAt(x);
            if (c < '!' || c > '~') {
                return true;
            }
            for (char cx : charsToNotHave) {
                if (c != cx) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean notPrintableOrHasWildGt(String s) {
        return Validator.notPrintableOrHasChars(s, WILD_GT);
    }

    private static boolean notPrintableOrHasWildGtDot(String s) {
        return Validator.notPrintableOrHasChars(s, WILD_GT_DOT);
    }

    private static boolean notPrintableOrHasWildGtDollar(String s) {
        return Validator.notPrintableOrHasChars(s, WILD_GT_DOLLAR);
    }

    public static String emptyAsNull(String s) {
        return Validator.nullOrEmpty(s) ? null : s;
    }

    public static boolean zeroOrLtMinus1(long l) {
        return l == 0L || l < -1L;
    }

    static interface Check {
        public String check(String var1, String var2);
    }
}

