/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.impl.NatsMessage;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class NatsJetStreamMetaData {
    private static final long NANO_FACTOR = 1000000000L;
    private final String stream;
    private final String consumer;
    private final long delivered;
    private final long streamSeq;
    private final long consumerSeq;
    private final ZonedDateTime timestamp;
    private long pending = -1L;

    public String toString() {
        return "NatsJetStreamMetaData{stream='" + this.stream + '\'' + ", consumer='" + this.consumer + '\'' + ", delivered=" + this.delivered + ", streamSeq=" + this.streamSeq + ", consumerSeq=" + this.consumerSeq + ", timestamp=" + this.timestamp + ", pending=" + this.pending + '}';
    }

    public NatsJetStreamMetaData(NatsMessage natsMessage) {
        String[] parts;
        if (!natsMessage.isJetStream()) {
            this.throwNotAJetStreamMessage(natsMessage.getReplyTo());
        }
        if ((parts = natsMessage.getReplyTo().split("\\.")).length < 8 || parts.length > 9 || !"ACK".equals(parts[1])) {
            this.throwNotAJetStreamMessage(natsMessage.getReplyTo());
        }
        this.stream = parts[2];
        this.consumer = parts[3];
        this.delivered = Long.parseLong(parts[4]);
        this.streamSeq = Long.parseLong(parts[5]);
        this.consumerSeq = Long.parseLong(parts[6]);
        long tsi = Long.parseLong(parts[7]);
        long seconds = tsi / 1000000000L;
        int nanos = (int)(tsi - tsi / 1000000000L * 1000000000L);
        LocalDateTime ltd = LocalDateTime.ofEpochSecond(seconds, nanos, OffsetDateTime.now().getOffset());
        this.timestamp = ZonedDateTime.of(ltd, ZoneId.systemDefault());
        if (parts.length == 9) {
            this.pending = Long.parseLong(parts[8]);
        }
    }

    public String getStream() {
        return this.stream;
    }

    public String getConsumer() {
        return this.consumer;
    }

    public long deliveredCount() {
        return this.delivered;
    }

    public long streamSequence() {
        return this.streamSeq;
    }

    public long consumerSequence() {
        return this.consumerSeq;
    }

    public long pendingCount() {
        return this.pending;
    }

    public ZonedDateTime timestamp() {
        return this.timestamp;
    }

    private void throwNotAJetStreamMessage(String subject) {
        throw new IllegalArgumentException("Message is not a JetStream message.  ReplySubject: <" + subject + ">");
    }
}

