/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonUtils;

public class AccountLimits {
    private final long maxMemory;
    private final long maxStorage;
    private final long maxStreams;
    private final long maxConsumers;

    AccountLimits(String json) {
        this.maxMemory = JsonUtils.readLong(json, ApiConstants.MAX_MEMORY_RE, -1L);
        this.maxStorage = JsonUtils.readLong(json, ApiConstants.MAX_STORAGE_RE, -1L);
        this.maxStreams = JsonUtils.readLong(json, ApiConstants.MAX_STREAMS_RE, -1L);
        this.maxConsumers = JsonUtils.readLong(json, ApiConstants.MAX_CONSUMERS_RE, -1L);
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getMaxStorage() {
        return this.maxStorage;
    }

    public long getMaxStreams() {
        return this.maxStreams;
    }

    public long getMaxConsumers() {
        return this.maxConsumers;
    }

    public String toString() {
        return "AccountLimitImpl{memory=" + this.maxMemory + ", storage=" + this.maxStorage + ", streams=" + this.maxStreams + ", consumers=" + this.maxConsumers + '}';
    }
}

